/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.math.Averagable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

public class PredictionAverage
extends MeasuredPerformance {
    private double sum;
    private double squaredSum;
    private int count;

    public void writeCriterionData(PrintWriter out) throws IOException {
        out.println("sum: " + this.sum);
        out.println("squares_sum: " + this.squaredSum);
        out.println("example_count: " + this.count);
    }

    public void readCriterionData(BufferedReader in) throws IOException {
        String line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.sum = Double.parseDouble(line);
        line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.squaredSum = Double.parseDouble(line);
        line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.count = Integer.parseInt(line);
    }

    public int getExampleCount() {
        return this.count;
    }

    public void countExample(Example example) {
        ++this.count;
        double v = example.getValue(example.getAttribute("prediction"));
        if (!Double.isNaN(v)) {
            this.sum += v;
            this.squaredSum += v * v;
        }
    }

    public double getValue() {
        return this.sum / (double)this.count;
    }

    public double getVariance() {
        double avg = this.getValue();
        return this.squaredSum / (double)this.count - avg * avg;
    }

    public void startCounting(ExampleSet set) {
        this.count = 0;
        this.sum = 0.0;
    }

    public String getName() {
        return "prediction_average";
    }

    public double getFitness() {
        return 0.0;
    }

    protected void cloneAveragable(Averagable newPC) {
        PredictionAverage pa = (PredictionAverage)newPC;
        this.sum = pa.sum;
        this.squaredSum = pa.squaredSum;
        this.count = pa.count;
    }

    public void buildSingleAverage(Averagable performance) {
        PredictionAverage other = (PredictionAverage)performance;
        this.sum += other.sum;
        this.squaredSum += other.squaredSum;
        this.count += other.count;
    }

    public String getDescription() {
        return "This is not a real performance measure, but merely the average of the predicted labels.";
    }
}

