/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import edu.udo.cs.yale.operator.performance.BinaryClassificationPerformance;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.operator.performance.MultiClassificationPerformance;
import edu.udo.cs.yale.operator.performance.PerformanceComparator;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.operator.performance.SquaredError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PerformanceEvaluator
extends Operator {
    private static Map classnameMap;
    private static final String[] CRITERIA_NAMES;
    private static final Class[] CRITERIA_CLASSES;
    private static String[] allCriteriaNames;
    private static String[] allCriteriaDescriptions;
    private static final int NUMBER_OF_USER_CRITERIA = 3;
    private PerformanceVector performanceCriteria;
    private ArrayList userCriteria;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$AbsoluteError;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$RelativeAbsoluteError;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$RootMeanSquaredError;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$RootRelativeSquaredError;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$SquaredError;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$CorrelationCriterion;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$SquaredCorrelationCriterion;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PredictionAverage;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$MDLCriterion;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceCriterion;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceComparator;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;

    public PerformanceEvaluator(OperatorDescription description) {
        super(description);
        int i;
        for (i = 0; i < CRITERIA_NAMES.length; ++i) {
            this.addPerformanceValue(CRITERIA_NAMES[i], allCriteriaDescriptions[i]);
        }
        for (i = 0; i < MultiClassificationPerformance.NAME.length; ++i) {
            this.addPerformanceValue(MultiClassificationPerformance.NAME[i], MultiClassificationPerformance.DESCRIPTION[i]);
        }
        for (i = 0; i < BinaryClassificationPerformance.NAME.length; ++i) {
            this.addPerformanceValue(BinaryClassificationPerformance.NAME[i], BinaryClassificationPerformance.DESCRIPTION[i]);
        }
        for (i = 0; i < 3; ++i) {
            this.addPerformanceValue("user:" + (i + 1), "The user defined performance criterion " + i);
        }
    }

    private void addPerformanceValue(final String name, String description) {
        this.addValue(new Value(name, description){

            public double getValue() {
                if (PerformanceEvaluator.this.performanceCriteria == null) {
                    return Double.NaN;
                }
                PerformanceCriterion c = null;
                if (name.startsWith("user:")) {
                    int index = Integer.parseInt(name.substring(5)) - 1;
                    c = (PerformanceCriterion)PerformanceEvaluator.this.userCriteria.get(index);
                } else {
                    c = PerformanceEvaluator.this.performanceCriteria.getCriterion(name);
                }
                if (c != null) {
                    return c.getValue();
                }
                return Double.NaN;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialisePerformanceVector(ExampleSet testSet) throws OperatorException {
        int i;
        this.performanceCriteria = new PerformanceVector();
        this.userCriteria = new ArrayList();
        for (i = 0; i < CRITERIA_NAMES.length; ++i) {
            if (!this.getParameterAsBoolean(CRITERIA_NAMES[i])) continue;
            try {
                this.performanceCriteria.addCriterion((PerformanceCriterion)CRITERIA_CLASSES[i].newInstance());
                continue;
            }
            catch (InstantiationException e) {
                LogService.logMessage("Cannot instantiate " + CRITERIA_CLASSES[i] + ".", 6);
                continue;
            }
            catch (IllegalAccessException e) {
                LogService.logMessage("Cannot instantiate " + CRITERIA_CLASSES[i] + ".", 6);
            }
        }
        for (i = 0; i < MultiClassificationPerformance.NAME.length; ++i) {
            if (!this.getParameterAsBoolean(MultiClassificationPerformance.NAME[i])) continue;
            this.performanceCriteria.addCriterion(new MultiClassificationPerformance(i));
        }
        for (i = 0; i < BinaryClassificationPerformance.NAME.length; ++i) {
            if (!this.getParameterAsBoolean(BinaryClassificationPerformance.NAME[i])) continue;
            this.performanceCriteria.addCriterion(new BinaryClassificationPerformance(i));
        }
        Iterator i2 = this.getParameterList("additional_performance_criteria").iterator();
        while (i2.hasNext()) {
            Object[] keyValue = (Object[])i2.next();
            String className = (String)keyValue[0];
            String parameter = (String)keyValue[1];
            Class criterionClass = null;
            try {
                criterionClass = Tools.classForName(className);
                if ((class$edu$udo$cs$yale$operator$performance$PerformanceCriterion == null ? PerformanceEvaluator.class$("edu.udo.cs.yale.operator.performance.PerformanceCriterion") : class$edu$udo$cs$yale$operator$performance$PerformanceCriterion).isAssignableFrom(criterionClass)) {
                    PerformanceCriterion c = null;
                    if (parameter != null && parameter.trim().length() > 0) {
                        Constructor constructor = criterionClass.getConstructor(class$java$lang$String == null ? PerformanceEvaluator.class$("java.lang.String") : class$java$lang$String);
                        c = (PerformanceCriterion)constructor.newInstance(parameter);
                    } else {
                        c = (PerformanceCriterion)criterionClass.newInstance();
                    }
                    this.performanceCriteria.addCriterion(c);
                    this.userCriteria.add(c);
                    continue;
                }
                throw new UserError((Operator)this, 914, new Object[]{criterionClass, class$edu$udo$cs$yale$operator$performance$PerformanceCriterion == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceCriterion = PerformanceEvaluator.class$("edu.udo.cs.yale.operator.performance.PerformanceCriterion")) : class$edu$udo$cs$yale$operator$performance$PerformanceCriterion});
            }
            catch (ClassNotFoundException e) {
                throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{criterionClass, e});
            }
            catch (InstantiationException e) {
                throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{criterionClass, e});
            }
            catch (IllegalAccessException e) {
                throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{criterionClass, e});
            }
            catch (NoSuchMethodException e) {
                throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{criterionClass, e});
            }
            catch (InvocationTargetException e) {
                throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{criterionClass, e});
            }
        }
        if (this.performanceCriteria.size() == 0) {
            LogService.logMessage(this.getName() + ": No performance criterion defined! Please define proper parameters. For now, trying...", 4);
            Attribute labelAttribute = testSet.getLabel();
            if (labelAttribute == null) {
                LogService.logMessage(this.getName() + ": Not possible to determine type of label. Error.", 4);
                throw new UserError(this, 910);
            }
            if (labelAttribute.isNominal()) {
                LogService.logMessage(this.getName() + ": label is nominal -- using 'accuracy'.", 4);
                this.performanceCriteria.addCriterion(new MultiClassificationPerformance(0));
                this.performanceCriteria.setMainCriterionName("accuracy");
            } else {
                LogService.logMessage(this.getName() + ": label is numerical -- using 'root mean squared error'.", 4);
                this.performanceCriteria.addCriterion(new SquaredError());
                this.performanceCriteria.setMainCriterionName("root_mean_squared_error");
            }
        } else {
            this.performanceCriteria.setMainCriterionName(this.getParameterAsString("main_criterion"));
        }
        String comparatorClass = this.getParameterAsString("comparator_class");
        if (comparatorClass == null) {
            this.performanceCriteria.setComparator(new PerformanceVector.DefaultComparator(this.getParameterAsDouble("mdl_weight")));
            return;
        }
        try {
            Class pcClass = Tools.classForName(comparatorClass);
            if ((class$edu$udo$cs$yale$operator$performance$PerformanceComparator == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceComparator = PerformanceEvaluator.class$("edu.udo.cs.yale.operator.performance.PerformanceComparator")) : class$edu$udo$cs$yale$operator$performance$PerformanceComparator).isAssignableFrom(pcClass)) {
                this.performanceCriteria.setComparator((PerformanceComparator)pcClass.newInstance());
                return;
            }
            throw new UserError((Operator)this, 914, new Object[]{pcClass, class$edu$udo$cs$yale$operator$performance$PerformanceComparator == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceComparator = PerformanceEvaluator.class$("edu.udo.cs.yale.operator.performance.PerformanceComparator")) : class$edu$udo$cs$yale$operator$performance$PerformanceComparator});
        }
        catch (Throwable e) {
            throw new UserError((Operator)this, e, 904, new Object[]{comparatorClass, e});
        }
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet testSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = PerformanceEvaluator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        PerformanceVector performance = this.evaluate(testSet);
        return new IOObject[]{performance};
    }

    protected PerformanceVector evaluate(ExampleSet testSet) throws OperatorException {
        this.initialisePerformanceVector(testSet);
        return this.evaluate(testSet, this.performanceCriteria);
    }

    protected PerformanceVector evaluate(ExampleSet testSet, PerformanceVector performanceCriteria) throws OperatorException {
        PerformanceEvaluator.evaluate(this, testSet, performanceCriteria, this.getParameterAsBoolean("skip_undefined_labels"));
        return performanceCriteria;
    }

    public static void evaluate(PerformanceEvaluator evaluator, ExampleSet testSet, PerformanceVector performanceCriteria, boolean skipUndefinedLabels) throws OperatorException {
        if (testSet.getLabel() == null) {
            throw new UserError((Operator)evaluator, 105, new Object[0]);
        }
        if (testSet.getPredictedLabel() == null) {
            throw new UserError((Operator)evaluator, 107, new Object[0]);
        }
        for (int pc = 0; pc < performanceCriteria.size(); ++pc) {
            PerformanceCriterion c = performanceCriteria.getCriterion(pc);
            if (!(c instanceof MeasuredPerformance)) {
                throw new UserError((Operator)evaluator, 903, new Object[0]);
            }
            ((MeasuredPerformance)c).startCounting(testSet);
        }
        ExampleReader exampleIterator = testSet.getExampleReader();
        while (exampleIterator.hasNext()) {
            Example example = exampleIterator.next();
            if (skipUndefinedLabels && (Double.isNaN(example.getLabel()) || Double.isNaN(example.getPredictedLabel()))) continue;
            for (int pc = 0; pc < performanceCriteria.size(); ++pc) {
                ((MeasuredPerformance)performanceCriteria.getCriterion(pc)).countExample(example);
            }
        }
    }

    public InputDescription getInputDescription(Class cls) {
        if ((class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = PerformanceEvaluator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet).isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = PerformanceEvaluator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = PerformanceEvaluator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector};
    }

    public List getParameterTypes() {
        int i;
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeStringCategory("main_criterion", "The criterion used for comparing performance vectors.", allCriteriaNames, allCriteriaNames[0]);
        type.setExpert(false);
        types.add(type);
        for (i = 0; i < CRITERIA_NAMES.length; ++i) {
            type = new ParameterTypeBoolean(CRITERIA_NAMES[i], allCriteriaDescriptions[i], false);
            type.setExpert(false);
            types.add(type);
        }
        for (i = 0; i < MultiClassificationPerformance.NAME.length; ++i) {
            type = new ParameterTypeBoolean(MultiClassificationPerformance.NAME[i], MultiClassificationPerformance.DESCRIPTION[i], false);
            type.setExpert(false);
            types.add(type);
        }
        for (i = 0; i < BinaryClassificationPerformance.NAME.length; ++i) {
            type = new ParameterTypeBoolean(BinaryClassificationPerformance.NAME[i], BinaryClassificationPerformance.DESCRIPTION[i], false);
            type.setExpert(false);
            types.add(type);
        }
        types.add(new ParameterTypeDouble("mdl_weight", "The weight for the mdl criteria if used for performance comparisons.", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeBoolean("skip_undefined_labels", "If set to true, examples with undefined labels are skipped.", false));
        types.add(new ParameterTypeString("comparator_class", "Fully qualified classname of the PerformanceComparator implementation.", true));
        types.add(new ParameterTypeList("additional_performance_criteria", "List of classes that implement edu.udo.cs.yale.operator.performance.PerformanceCriterion.", new ParameterTypeString("additional_performance_criteria", "The key must be a fully qualified classname and the value may be a string that is passed to the constructor of this class.", false)));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i;
        CRITERIA_NAMES = new String[]{"absolute_error", "relative_absolute_error", "root_mean_squared_error", "root_relative_squared_error", "squared_error", "correlation", "squared_correlation", "prediction_average", "mdl"};
        CRITERIA_CLASSES = new Class[]{class$edu$udo$cs$yale$operator$performance$AbsoluteError == null ? (class$edu$udo$cs$yale$operator$performance$AbsoluteError = PerformanceEvaluator.class$("edu.udo.cs.yale.operator.performance.AbsoluteError")) : class$edu$udo$cs$yale$operator$performance$AbsoluteError, class$edu$udo$cs$yale$operator$performance$RelativeAbsoluteError == null ? (class$edu$udo$cs$yale$operator$performance$RelativeAbsoluteError = PerformanceEvaluator.class$("edu.udo.cs.yale.operator.performance.RelativeAbsoluteError")) : class$edu$udo$cs$yale$operator$performance$RelativeAbsoluteError, class$edu$udo$cs$yale$operator$performance$RootMeanSquaredError == null ? (class$edu$udo$cs$yale$operator$performance$RootMeanSquaredError = PerformanceEvaluator.class$("edu.udo.cs.yale.operator.performance.RootMeanSquaredError")) : class$edu$udo$cs$yale$operator$performance$RootMeanSquaredError, class$edu$udo$cs$yale$operator$performance$RootRelativeSquaredError == null ? (class$edu$udo$cs$yale$operator$performance$RootRelativeSquaredError = PerformanceEvaluator.class$("edu.udo.cs.yale.operator.performance.RootRelativeSquaredError")) : class$edu$udo$cs$yale$operator$performance$RootRelativeSquaredError, class$edu$udo$cs$yale$operator$performance$SquaredError == null ? (class$edu$udo$cs$yale$operator$performance$SquaredError = PerformanceEvaluator.class$("edu.udo.cs.yale.operator.performance.SquaredError")) : class$edu$udo$cs$yale$operator$performance$SquaredError, class$edu$udo$cs$yale$operator$performance$CorrelationCriterion == null ? (class$edu$udo$cs$yale$operator$performance$CorrelationCriterion = PerformanceEvaluator.class$("edu.udo.cs.yale.operator.performance.CorrelationCriterion")) : class$edu$udo$cs$yale$operator$performance$CorrelationCriterion, class$edu$udo$cs$yale$operator$performance$SquaredCorrelationCriterion == null ? (class$edu$udo$cs$yale$operator$performance$SquaredCorrelationCriterion = PerformanceEvaluator.class$("edu.udo.cs.yale.operator.performance.SquaredCorrelationCriterion")) : class$edu$udo$cs$yale$operator$performance$SquaredCorrelationCriterion, class$edu$udo$cs$yale$operator$performance$PredictionAverage == null ? (class$edu$udo$cs$yale$operator$performance$PredictionAverage = PerformanceEvaluator.class$("edu.udo.cs.yale.operator.performance.PredictionAverage")) : class$edu$udo$cs$yale$operator$performance$PredictionAverage, class$edu$udo$cs$yale$operator$performance$MDLCriterion == null ? (class$edu$udo$cs$yale$operator$performance$MDLCriterion = PerformanceEvaluator.class$("edu.udo.cs.yale.operator.performance.MDLCriterion")) : class$edu$udo$cs$yale$operator$performance$MDLCriterion};
        int numberOfCriteria = CRITERIA_NAMES.length + MultiClassificationPerformance.NAME.length + BinaryClassificationPerformance.NAME.length;
        allCriteriaNames = new String[numberOfCriteria];
        allCriteriaDescriptions = new String[numberOfCriteria];
        System.arraycopy(CRITERIA_NAMES, 0, allCriteriaNames, 0, CRITERIA_NAMES.length);
        for (i = 0; i < CRITERIA_CLASSES.length; ++i) {
            PerformanceEvaluator.allCriteriaDescriptions[i] = "The performance criterion " + CRITERIA_NAMES[i] + " error.";
            try {
                PerformanceEvaluator.allCriteriaDescriptions[i] = ((MeasuredPerformance)CRITERIA_CLASSES[i].newInstance()).getDescription();
                continue;
            }
            catch (Throwable t) {
                LogService.logException("Cannot instantiate '" + CRITERIA_CLASSES[i] + "'!", t);
            }
        }
        System.arraycopy(MultiClassificationPerformance.NAME, 0, allCriteriaNames, CRITERIA_NAMES.length, MultiClassificationPerformance.NAME.length);
        System.arraycopy(MultiClassificationPerformance.DESCRIPTION, 0, allCriteriaDescriptions, CRITERIA_NAMES.length, MultiClassificationPerformance.DESCRIPTION.length);
        System.arraycopy(BinaryClassificationPerformance.NAME, 0, allCriteriaNames, CRITERIA_NAMES.length + MultiClassificationPerformance.NAME.length, BinaryClassificationPerformance.NAME.length);
        System.arraycopy(BinaryClassificationPerformance.DESCRIPTION, 0, allCriteriaDescriptions, CRITERIA_NAMES.length + MultiClassificationPerformance.NAME.length, BinaryClassificationPerformance.DESCRIPTION.length);
        classnameMap = new HashMap();
        for (i = 0; i < CRITERIA_NAMES.length; ++i) {
            classnameMap.put(CRITERIA_NAMES[i], CRITERIA_CLASSES[i]);
        }
    }
}

