/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.math.Averagable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

public class MDLCriterion
extends MeasuredPerformance {
    private int length;

    public void writeCriterionData(PrintWriter out) throws IOException {
        out.println("length: " + this.length);
    }

    public void readCriterionData(BufferedReader in) throws IOException {
        String line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.length = Integer.parseInt(line);
    }

    public String getName() {
        return "mdl";
    }

    public String getDescription() {
        return "Measures the length of an example set (i.e. the number of attributes).";
    }

    public void startCounting(ExampleSet eSet) throws OperatorException {
        super.startCounting(eSet);
        this.length = eSet instanceof AttributeWeightedExampleSet ? ((AttributeWeightedExampleSet)eSet).getNumberOfUsedAttributes() : eSet.getNumberOfAttributes();
    }

    public int getExampleCount() {
        return 1;
    }

    public void countExample(Example example) {
    }

    public double getFitness() {
        return 1.0 / (double)this.length;
    }

    public double getValue() {
        return this.length;
    }

    public double getVariance() {
        return 0.0;
    }

    public void cloneAveragable(Averagable other) {
        this.length = ((MDLCriterion)other).length;
    }

    public void buildSingleAverage(Averagable averagable) {
        MDLCriterion other = (MDLCriterion)averagable;
        this.length += other.length;
    }
}

