/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IODescription;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.util.List;

public class RandomOptimizationChain
extends OperatorChain {
    private int iteration;
    private double currentBestPerformance = Double.NaN;
    private double avgPerformance = 0.0;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;

    public RandomOptimizationChain(OperatorDescription description) {
        super(description);
        this.addValue(new Value("iteration", "The number of the current iteration."){

            public double getValue() {
                return RandomOptimizationChain.this.iteration;
            }
        });
        this.addValue(new Value("performance", "The current best performance"){

            public double getValue() {
                return RandomOptimizationChain.this.currentBestPerformance;
            }
        });
        this.addValue(new Value("avg_performance", "The average performance"){

            public double getValue() {
                return RandomOptimizationChain.this.avgPerformance;
            }
        });
    }

    public IOObject[] apply() throws OperatorException {
        int numCycles = this.getParameterAsInt("iterations");
        this.iteration = 0;
        double maxValue = Double.NEGATIVE_INFINITY;
        double perfSum = 0.0;
        IOContainer bestResult = null;
        for (int i = 0; i < numCycles; ++i) {
            IOContainer io = this.applyInnerLoop();
            PerformanceVector perf = (PerformanceVector)io.remove(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? RandomOptimizationChain.class$("edu.udo.cs.yale.operator.performance.PerformanceVector") : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
            perfSum += perf.getMainCriterion().getValue();
            if (perf.getMainCriterion().getFitness() > maxValue) {
                maxValue = perf.getMainCriterion().getFitness();
                bestResult = io;
            }
            this.currentBestPerformance = maxValue;
            ++this.iteration;
            this.avgPerformance = perfSum / (double)this.iteration;
        }
        return bestResult.getIOObjects();
    }

    private IOContainer applyInnerLoop() throws OperatorException {
        IOContainer container = this.getInput().copy();
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            container = this.getOperator(i).apply(container);
        }
        return container;
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[0];
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            input = this.getOperator(i).checkIO(input);
        }
        if (!IODescription.containsClass(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = RandomOptimizationChain.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector, input)) {
            throw new IllegalInputException((Operator)this, "The inner operators of RandomOptimizer must return a PerformanceVector");
        }
        return this.getAllOutputClasses(input);
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public int getNumberOfSteps() {
        return this.getNumberOfChildrensSteps();
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt("iterations", "The number of iterations to perform", 1, Integer.MAX_VALUE, false));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

