/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeNumber;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.Iterator;
import java.util.List;

public abstract class ParameterOptimizationOperator
extends OperatorChain {
    protected List parameterList;
    protected Operator[] operators;
    protected String[] parameters;
    protected double[] logBase;
    protected String[][] values;
    protected int[] currentIndex;
    protected boolean scaleOn;
    protected int numberOfCombinations = 1;

    public ParameterOptimizationOperator(OperatorDescription description) {
        super(description);
    }

    protected double param2coded(String value, double base) {
        if (this.scaleOn) {
            double res = Double.parseDouble(value);
            return Math.log(res) / Math.log(base);
        }
        return Double.parseDouble(value);
    }

    protected String coded2param(double value, double base) {
        if (this.scaleOn) {
            return Double.toString(Math.exp(Math.log(base) * value));
        }
        return Double.toString(value);
    }

    protected double param2coded4RangeVerification(double value, double base) {
        if (this.scaleOn) {
            return Math.log(value) / Math.log(base);
        }
        return value;
    }

    protected double coded2param4RangeVerification(double value, double base) {
        if (this.scaleOn) {
            return Math.exp(Math.log(base) * value);
        }
        return value;
    }

    public void getParametersToOptimize() throws OperatorException {
        this.parameterList = this.getParameterList("parameters");
        this.operators = new Operator[this.parameterList.size()];
        this.parameters = new String[this.parameterList.size()];
        this.logBase = new double[this.parameterList.size()];
        this.values = new String[this.parameterList.size()][];
        this.currentIndex = new int[this.parameterList.size()];
        int index = 0;
        Iterator iter = this.parameterList.iterator();
        while (iter.hasNext()) {
            Object[] keyValue = (Object[])iter.next();
            String[] parameter = ((String)keyValue[0]).split("\\.");
            if (parameter.length < 2 || parameter.length > 3) {
                throw new UserError((Operator)this, 907, keyValue[0]);
            }
            Operator operator = this.getExperiment().getOperator(parameter[0]);
            if (operator == null) {
                throw new UserError((Operator)this, 109, parameter[0]);
            }
            this.operators[index] = operator;
            this.parameters[index] = parameter[1];
            ParameterType targetType = this.operators[index].getParameters().getParameterType(this.parameters[index]);
            if (targetType == null) {
                throw new UserError((Operator)this, 906, parameter[0] + "." + parameter[1]);
            }
            if (!(targetType instanceof ParameterTypeNumber)) {
                throw new UserError((Operator)this, 909, parameter[0] + "." + parameter[1]);
            }
            if (parameter.length < 3) {
                this.logBase[index] = 2.0;
            } else {
                try {
                    this.logBase[index] = Double.parseDouble(parameter[2]);
                }
                catch (NumberFormatException e) {
                    throw new UserError((Operator)this, 907, keyValue[0] + "." + keyValue[1]);
                }
            }
            this.values[index] = ((String)keyValue[1]).split(",");
            this.numberOfCombinations *= this.values[index].length;
            ++index;
        }
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterType type = new ParameterTypeList("parameters", "define all Parameters to optimize", new ParameterTypeString("value(s)", "The value(s) of the parameter (comma-separated if more than one)"));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean("log_scale", "Set if parameter values are scaled as specified in the parameters section", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

