/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.weka;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.SerializableModel;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.WekaTools;
import java.awt.Component;
import weka.classifiers.Classifier;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeDisplayEvent;
import weka.gui.treevisualizer.TreeDisplayListener;
import weka.gui.treevisualizer.TreeVisualizer;

public class WekaClassifier
extends SerializableModel {
    private Classifier classifier;

    protected WekaClassifier() {
    }

    public WekaClassifier(Attribute label) {
        super(label);
    }

    public WekaClassifier(Attribute label, Classifier classifier) {
        super(label);
        this.classifier = classifier;
    }

    public void apply(ExampleSet exampleSet) throws OperatorException {
        LogService.logMessage("Applying Weka classifier.", 2);
        LogService.logMessage("Converting to Weka instances.", 0);
        Attribute predictedLabel = exampleSet.getPredictedLabel();
        Instances instances = WekaTools.toWekaInstances(exampleSet, "ApplierInstances", predictedLabel, false);
        LogService.logMessage("Applying Weka classifier.", 0);
        int i = 0;
        ExampleReader r = exampleSet.getExampleReader();
        while (r.hasNext()) {
            Example e = r.next();
            Instance instance = instances.instance(i++);
            this.applyModelForInstance(instance, e, predictedLabel);
        }
    }

    public void applyModelForInstance(Instance instance, Example e, Attribute predictedLabelAttribute) {
        double predictedLabel = Double.NaN;
        try {
            double wekaPrediction = this.classifier.classifyInstance(instance);
            if (predictedLabelAttribute.isNominal()) {
                double[] confidences = this.classifier.distributionForInstance(instance);
                for (int i = 0; i < confidences.length; ++i) {
                    String classification = instance.classAttribute().value(i);
                    e.setConfidence(classification, confidences[i]);
                }
                String classification = instance.classAttribute().value((int)wekaPrediction);
                predictedLabel = predictedLabelAttribute.mapString(classification);
            } else {
                predictedLabel = this.classifier.classifyInstance(instance);
            }
        }
        catch (Exception exc) {
            LogService.logMessage("Exception occured while classifying example:" + exc.getMessage() + " [" + exc.getClass() + "]", 6);
            exc.printStackTrace();
        }
        e.setPredictedLabel(predictedLabel);
    }

    public String toString() {
        return "Weka model (" + this.classifier.getClass().getName() + ") for label " + this.getLabel() + "\n" + this.classifier.toString();
    }

    public String toResultString() {
        return this.classifier.toString();
    }

    public Component getVisualisationComponent() {
        if (this.classifier instanceof Drawable) {
            try {
                Drawable drawable = (Drawable)this.classifier;
                return new TreeVisualizer(new TreeDisplayListener(){

                    public void userCommand(TreeDisplayEvent e) {
                    }
                }, drawable.graph(), (NodePlace)new PlaceNode2());
            }
            catch (Exception e) {
                e.printStackTrace();
                return super.getVisualisationComponent();
            }
        }
        return super.getVisualisationComponent();
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        WekaClassifier other = (WekaClassifier)o;
        return other.classifier.getClass().equals(this.classifier.getClass());
    }
}

