/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.weka;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.associations.AprioriItemSet;
import weka.associations.Associator;
import weka.core.AttributeStats;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class Apriori
extends Associator
implements OptionHandler {
    protected double m_minSupport;
    protected double m_upperBoundMinSupport;
    protected double m_lowerBoundMinSupport;
    protected static final int CONFIDENCE = 0;
    protected static final int LIFT = 1;
    protected static final int LEVERAGE = 2;
    protected static final int CONVICTION = 3;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(0, "Confidence"), new Tag(1, "Lift"), new Tag(2, "Leverage"), new Tag(3, "Conviction")};
    protected int m_metricType = 0;
    protected double m_minMetric;
    protected int m_numRules;
    protected double m_delta;
    protected double m_significanceLevel;
    protected int m_cycles;
    protected FastVector m_Ls;
    protected FastVector m_hashtables;
    protected FastVector[] m_allTheRules;
    protected Instances m_instances;
    protected boolean m_outputItemSets;
    protected boolean m_removeMissingCols;
    protected boolean m_verbose;

    public String globalInfo() {
        return "Finds association rules.";
    }

    public Apriori() {
        this.resetOptions();
    }

    public void resetOptions() {
        this.m_removeMissingCols = false;
        this.m_verbose = false;
        this.m_delta = 0.05;
        this.m_minMetric = 0.9;
        this.m_numRules = 10;
        this.m_lowerBoundMinSupport = 0.1;
        this.m_upperBoundMinSupport = 1.0;
        this.m_significanceLevel = -1.0;
        this.m_outputItemSets = false;
    }

    protected Instances removeMissingColumns(Instances instances) throws Exception {
        int numInstances = instances.numInstances();
        StringBuffer deleteString = new StringBuffer();
        int removeCount = 0;
        boolean first = true;
        int maxCount = 0;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            int[] counts;
            AttributeStats as = instances.attributeStats(i);
            if (this.m_upperBoundMinSupport == 1.0 && maxCount != numInstances && (counts = as.nominalCounts)[Utils.maxIndex((int[])counts)] > maxCount) {
                maxCount = counts[Utils.maxIndex((int[])counts)];
            }
            if (as.missingCount != numInstances) continue;
            if (first) {
                deleteString.append(i + 1);
                first = false;
            } else {
                deleteString.append("," + (i + 1));
            }
            ++removeCount;
        }
        if (this.m_verbose) {
            System.err.println("Removed : " + removeCount + " columns with all missing " + "values.");
        }
        if (this.m_upperBoundMinSupport == 1.0 && maxCount != numInstances) {
            this.m_upperBoundMinSupport = (double)maxCount / (double)numInstances;
            if (this.m_verbose) {
                System.err.println("Setting upper bound min support to : " + this.m_upperBoundMinSupport);
            }
        }
        if (deleteString.toString().length() > 0) {
            Remove af = new Remove();
            af.setAttributeIndices(deleteString.toString());
            af.setInvertSelection(false);
            af.setInputFormat(instances);
            Instances newInst = Filter.useFilter((Instances)instances, (Filter)af);
            return newInst;
        }
        return instances;
    }

    public void buildAssociations(Instances instances) throws Exception {
        int necSupport = 0;
        if (instances.checkForStringAttributes()) {
            throw new Exception("Can't handle string attributes!");
        }
        if (this.m_removeMissingCols) {
            instances = this.removeMissingColumns(instances);
        }
        this.m_cycles = 0;
        this.m_minSupport = this.m_upperBoundMinSupport - this.m_delta;
        this.m_minSupport = this.m_minSupport < this.m_lowerBoundMinSupport ? this.m_lowerBoundMinSupport : this.m_minSupport;
        do {
            int i;
            int i2;
            this.m_Ls = new FastVector();
            this.m_hashtables = new FastVector();
            this.m_allTheRules = new FastVector[6];
            this.m_allTheRules[0] = new FastVector();
            this.m_allTheRules[1] = new FastVector();
            this.m_allTheRules[2] = new FastVector();
            if (this.m_metricType != 0 || this.m_significanceLevel != -1.0) {
                this.m_allTheRules[3] = new FastVector();
                this.m_allTheRules[4] = new FastVector();
                this.m_allTheRules[5] = new FastVector();
            }
            FastVector[] sortedRuleSet = new FastVector[6];
            sortedRuleSet[0] = new FastVector();
            sortedRuleSet[1] = new FastVector();
            sortedRuleSet[2] = new FastVector();
            if (this.m_metricType != 0 || this.m_significanceLevel != -1.0) {
                sortedRuleSet[3] = new FastVector();
                sortedRuleSet[4] = new FastVector();
                sortedRuleSet[5] = new FastVector();
            }
            this.findLargeItemSets(instances);
            if (this.m_significanceLevel != -1.0 || this.m_metricType != 0) {
                this.findRulesBruteForce();
            } else {
                this.findRulesQuickly();
            }
            double[] supports = new double[this.m_allTheRules[2].size()];
            for (i2 = 0; i2 < this.m_allTheRules[2].size(); ++i2) {
                supports[i2] = ((AprioriItemSet)this.m_allTheRules[1].elementAt(i2)).support();
            }
            int[] indices = Utils.stableSort((double[])supports);
            for (i2 = 0; i2 < this.m_allTheRules[2].size(); ++i2) {
                sortedRuleSet[0].addElement(this.m_allTheRules[0].elementAt(indices[i2]));
                sortedRuleSet[1].addElement(this.m_allTheRules[1].elementAt(indices[i2]));
                sortedRuleSet[2].addElement(this.m_allTheRules[2].elementAt(indices[i2]));
                if (this.m_metricType == 0 && this.m_significanceLevel == -1.0) continue;
                sortedRuleSet[3].addElement(this.m_allTheRules[3].elementAt(indices[i2]));
                sortedRuleSet[4].addElement(this.m_allTheRules[4].elementAt(indices[i2]));
                sortedRuleSet[5].addElement(this.m_allTheRules[5].elementAt(indices[i2]));
            }
            this.m_allTheRules[0].removeAllElements();
            this.m_allTheRules[1].removeAllElements();
            this.m_allTheRules[2].removeAllElements();
            if (this.m_metricType != 0 || this.m_significanceLevel != -1.0) {
                this.m_allTheRules[3].removeAllElements();
                this.m_allTheRules[4].removeAllElements();
                this.m_allTheRules[5].removeAllElements();
            }
            double[] confidences = new double[sortedRuleSet[2].size()];
            int sortType = 2 + this.m_metricType;
            for (i = 0; i < sortedRuleSet[2].size(); ++i) {
                confidences[i] = (Double)sortedRuleSet[sortType].elementAt(i);
            }
            indices = Utils.stableSort((double[])confidences);
            for (i = sortedRuleSet[0].size() - 1; i >= sortedRuleSet[0].size() - this.m_numRules && i >= 0; --i) {
                this.m_allTheRules[0].addElement(sortedRuleSet[0].elementAt(indices[i]));
                this.m_allTheRules[1].addElement(sortedRuleSet[1].elementAt(indices[i]));
                this.m_allTheRules[2].addElement(sortedRuleSet[2].elementAt(indices[i]));
                if (this.m_metricType == 0 && this.m_significanceLevel == -1.0) continue;
                this.m_allTheRules[3].addElement(sortedRuleSet[3].elementAt(indices[i]));
                this.m_allTheRules[4].addElement(sortedRuleSet[4].elementAt(indices[i]));
                this.m_allTheRules[5].addElement(sortedRuleSet[5].elementAt(indices[i]));
            }
            if (this.m_verbose && this.m_Ls.size() > 1) {
                System.out.println(this.toString());
            }
            this.m_minSupport -= this.m_delta;
            necSupport = (int)(this.m_minSupport * (double)instances.numInstances() + 0.5);
            ++this.m_cycles;
        } while (this.m_allTheRules[0].size() < this.m_numRules && Utils.grOrEq((double)this.m_minSupport, (double)this.m_lowerBoundMinSupport) && necSupport >= 1);
        this.m_minSupport += this.m_delta;
    }

    public Enumeration listOptions() {
        String string1 = "\tThe required number of rules. (default = " + this.m_numRules + ")";
        String string2 = "\tThe minimum confidence of a rule. (default = " + this.m_minMetric + ")";
        String string3 = "\tThe delta by which the minimum support is decreased in\n";
        String string4 = "\teach iteration. (default = " + this.m_delta + ")";
        String string5 = "\tThe lower bound for the minimum support. (default = " + this.m_lowerBoundMinSupport + ")";
        String string6 = "\tIf used, rules are tested for significance at\n";
        String string7 = "\tthe given level. Slower. (default = no significance testing)";
        String string8 = "\tIf set the itemsets found are also output. (default = no)";
        String stringType = "\tThe metric type by which to rank rules. (default = confidence)";
        FastVector newVector = new FastVector(9);
        newVector.addElement((Object)new Option(string1, "N", 1, "-N <required number of rules output>"));
        newVector.addElement((Object)new Option(stringType, "T", 1, "-T <0=confidence | 1=lift | 2=leverage | 3=Conviction>"));
        newVector.addElement((Object)new Option(string2, "C", 1, "-C <minimum metric score of a rule>"));
        newVector.addElement((Object)new Option(string3 + string4, "D", 1, "-D <delta for minimum support>"));
        newVector.addElement((Object)new Option("\tUpper bound for minimum support. (default = 1.0)", "U", 1, "-U <upper bound for minimum support>"));
        newVector.addElement((Object)new Option(string5, "M", 1, "-M <lower bound for minimum support>"));
        newVector.addElement((Object)new Option(string6 + string7, "S", 0, "-S <significance level>"));
        newVector.addElement((Object)new Option(string8, "I", 0, "-I"));
        newVector.addElement((Object)new Option("\tRemove columns that contain all missing values (default = no)", "R", 0, "-R"));
        newVector.addElement((Object)new Option("\tReport progress iteratively. (default = no)", "V", 0, "-V"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String numRulesString = Utils.getOption((char)'N', (String[])options);
        String minConfidenceString = Utils.getOption((char)'C', (String[])options);
        String deltaString = Utils.getOption((char)'D', (String[])options);
        String maxSupportString = Utils.getOption((char)'U', (String[])options);
        String minSupportString = Utils.getOption((char)'M', (String[])options);
        String significanceLevelString = Utils.getOption((char)'S', (String[])options);
        String metricTypeString = Utils.getOption((char)'T', (String[])options);
        if (metricTypeString.length() != 0) {
            this.setMetricType(new SelectedTag(Integer.parseInt(metricTypeString), TAGS_SELECTION));
        }
        if (numRulesString.length() != 0) {
            this.m_numRules = Integer.parseInt(numRulesString);
        }
        if (minConfidenceString.length() != 0) {
            this.m_minMetric = new Double(minConfidenceString);
        }
        if (deltaString.length() != 0) {
            this.m_delta = new Double(deltaString);
        }
        if (maxSupportString.length() != 0) {
            this.setUpperBoundMinSupport(new Double(maxSupportString));
        }
        if (minSupportString.length() != 0) {
            this.m_lowerBoundMinSupport = new Double(minSupportString);
        }
        if (significanceLevelString.length() != 0) {
            this.m_significanceLevel = new Double(significanceLevelString);
        }
        this.m_outputItemSets = Utils.getFlag((char)'I', (String[])options);
        this.m_verbose = Utils.getFlag((char)'V', (String[])options);
        this.setRemoveAllMissingCols(Utils.getFlag((char)'R', (String[])options));
    }

    public String[] getOptions() {
        String[] options = new String[16];
        int current = 0;
        if (this.m_outputItemSets) {
            options[current++] = "-I";
        }
        if (this.getRemoveAllMissingCols()) {
            options[current++] = "-R";
        }
        options[current++] = "-N";
        options[current++] = "" + this.m_numRules;
        options[current++] = "-T";
        options[current++] = "" + this.m_metricType;
        options[current++] = "-C";
        options[current++] = "" + this.m_minMetric;
        options[current++] = "-D";
        options[current++] = "" + this.m_delta;
        options[current++] = "-U";
        options[current++] = "" + this.m_upperBoundMinSupport;
        options[current++] = "-M";
        options[current++] = "" + this.m_lowerBoundMinSupport;
        options[current++] = "-S";
        options[current++] = "" + this.m_significanceLevel;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String toString() {
        int i;
        StringBuffer text = new StringBuffer();
        if (this.m_Ls.size() <= 1) {
            return "\nNo large itemsets and rules found!\n";
        }
        text.append("\nApriori\n=======\n\n");
        text.append("Minimum support: " + Utils.doubleToString((double)this.m_minSupport, (int)2) + '\n');
        text.append("Minimum metric <");
        switch (this.m_metricType) {
            case 0: {
                text.append("confidence>: ");
                break;
            }
            case 1: {
                text.append("lift>: ");
                break;
            }
            case 2: {
                text.append("leverage>: ");
                break;
            }
            case 3: {
                text.append("conviction>: ");
            }
        }
        text.append(Utils.doubleToString((double)this.m_minMetric, (int)2) + '\n');
        if (this.m_significanceLevel != -1.0) {
            text.append("Significance level: " + Utils.doubleToString((double)this.m_significanceLevel, (int)2) + '\n');
        }
        text.append("Number of cycles performed: " + this.m_cycles + '\n');
        text.append("\nGenerated sets of large itemsets:\n");
        for (i = 0; i < this.m_Ls.size(); ++i) {
            text.append("\nSize of set of large itemsets L(" + (i + 1) + "): " + ((FastVector)this.m_Ls.elementAt(i)).size() + '\n');
            if (!this.m_outputItemSets) continue;
            text.append("\nLarge Itemsets L(" + (i + 1) + "):\n");
            for (int j = 0; j < ((FastVector)this.m_Ls.elementAt(i)).size(); ++j) {
                text.append(((AprioriItemSet)((FastVector)this.m_Ls.elementAt(i)).elementAt(j)).toString(this.m_instances) + "\n");
            }
        }
        text.append("\nBest rules found:\n\n");
        for (i = 0; i < this.m_allTheRules[0].size(); ++i) {
            text.append(Utils.doubleToString((double)((double)i + 1.0), (int)((int)(Math.log(this.m_numRules) / Math.log(10.0) + 1.0)), (int)0) + ". " + ((AprioriItemSet)this.m_allTheRules[0].elementAt(i)).toString(this.m_instances) + " ==> " + ((AprioriItemSet)this.m_allTheRules[1].elementAt(i)).toString(this.m_instances) + "    conf:(" + Utils.doubleToString((double)((Double)this.m_allTheRules[2].elementAt(i)), (int)2) + ")");
            if (this.m_metricType != 0 || this.m_significanceLevel != -1.0) {
                text.append((this.m_metricType == 1 ? " <" : "") + " lift:(" + Utils.doubleToString((double)((Double)this.m_allTheRules[3].elementAt(i)), (int)2) + ")" + (this.m_metricType == 1 ? ">" : ""));
                text.append((this.m_metricType == 2 ? " <" : "") + " lev:(" + Utils.doubleToString((double)((Double)this.m_allTheRules[4].elementAt(i)), (int)2) + ")");
                text.append(" [" + (int)((Double)this.m_allTheRules[4].elementAt(i) * (double)this.m_instances.numInstances()) + "]" + (this.m_metricType == 2 ? ">" : ""));
                text.append((this.m_metricType == 3 ? " <" : "") + " conv:(" + Utils.doubleToString((double)((Double)this.m_allTheRules[5].elementAt(i)), (int)2) + ")" + (this.m_metricType == 3 ? ">" : ""));
            }
            text.append('\n');
        }
        return text.toString();
    }

    public String removeAllMissingColsTipText() {
        return "Remove columns with all missing values.";
    }

    public void setRemoveAllMissingCols(boolean r) {
        this.m_removeMissingCols = r;
    }

    public boolean getRemoveAllMissingCols() {
        return this.m_removeMissingCols;
    }

    public String upperBoundMinSupportTipText() {
        return "Upper bound for minimum support. Start iteratively decreasing minimum support from this value.";
    }

    public double getUpperBoundMinSupport() {
        return this.m_upperBoundMinSupport;
    }

    public void setUpperBoundMinSupport(double v) {
        this.m_upperBoundMinSupport = v;
    }

    public String lowerBoundMinSupportTipText() {
        return "Lower bound for minimum support.";
    }

    public double getLowerBoundMinSupport() {
        return this.m_lowerBoundMinSupport;
    }

    public void setLowerBoundMinSupport(double v) {
        this.m_lowerBoundMinSupport = v;
    }

    public SelectedTag getMetricType() {
        return new SelectedTag(this.m_metricType, TAGS_SELECTION);
    }

    public String metricTypeTipText() {
        return "Set the type of metric by which to rank rules. Confidence is the proportion of the examples covered by the premise that are also covered by the consequence. Lift is confidence divided by the proportion of all examples that are covered by the consequence. This is a measure of the importance of the association that is independent of support. Leverage is the proportion of additional examples covered by both the premise and consequence above those expected if the premise and consequence were independent of each other. The total number of examples that this represents is presented in brackets following the leverage. Conviction is another measure of departure from independence and furthermore takes into account implicaton. Conviction is given by P(premise)P(!consequence) / P(premise, !consequence).";
    }

    public void setMetricType(SelectedTag d) {
        if (d.getTags() == TAGS_SELECTION) {
            this.m_metricType = d.getSelectedTag().getID();
        }
        if (this.m_significanceLevel != -1.0 && this.m_metricType != 0) {
            this.m_metricType = 0;
        }
        if (this.m_metricType == 0) {
            this.setMinMetric(0.9);
        }
        if (this.m_metricType == 1 || this.m_metricType == 3) {
            this.setMinMetric(1.1);
        }
        if (this.m_metricType == 2) {
            this.setMinMetric(0.1);
        }
    }

    public String minMetricTipText() {
        return "Minimum metric score. Consider only rules with scores higher than this value.";
    }

    public double getMinMetric() {
        return this.m_minMetric;
    }

    public void setMinMetric(double v) {
        this.m_minMetric = v;
    }

    public String numRulesTipText() {
        return "Number of rules to find.";
    }

    public int getNumRules() {
        return this.m_numRules;
    }

    public void setNumRules(int v) {
        this.m_numRules = v;
    }

    public String deltaTipText() {
        return "Iteratively decrease support by this factor. Reduces support until min support is reached or required number of rules has been generated.";
    }

    public double getDelta() {
        return this.m_delta;
    }

    public void setDelta(double v) {
        this.m_delta = v;
    }

    public String significanceLevelTipText() {
        return "Significance level. Significance test (confidence metric only).";
    }

    public double getSignificanceLevel() {
        return this.m_significanceLevel;
    }

    public void setSignificanceLevel(double v) {
        this.m_significanceLevel = v;
    }

    private void findLargeItemSets(Instances instances) throws Exception {
        int i = 0;
        this.m_instances = instances;
        int necSupport = (int)(this.m_minSupport * (double)instances.numInstances() + 0.5);
        int necMaxSupport = (int)(this.m_upperBoundMinSupport * (double)instances.numInstances() + 0.5);
        FastVector kSets = AprioriItemSet.singletons((Instances)instances);
        AprioriItemSet.upDateCounters((FastVector)kSets, (Instances)instances);
        kSets = AprioriItemSet.deleteItemSets((FastVector)kSets, (int)necSupport, (int)necMaxSupport);
        if (kSets.size() == 0) {
            return;
        }
        do {
            this.m_Ls.addElement((Object)kSets);
            FastVector kMinusOneSets = kSets;
            kSets = AprioriItemSet.mergeAllItemSets((FastVector)kMinusOneSets, (int)i, (int)instances.numInstances());
            Hashtable hashtable = AprioriItemSet.getHashtable((FastVector)kMinusOneSets, (int)kMinusOneSets.size());
            this.m_hashtables.addElement((Object)hashtable);
            kSets = AprioriItemSet.pruneItemSets((FastVector)kSets, (Hashtable)hashtable);
            AprioriItemSet.upDateCounters((FastVector)kSets, (Instances)instances);
            kSets = AprioriItemSet.deleteItemSets((FastVector)kSets, (int)necSupport, (int)necMaxSupport);
            ++i;
        } while (kSets.size() > 0);
    }

    private void findRulesBruteForce() throws Exception {
        for (int j = 1; j < this.m_Ls.size(); ++j) {
            FastVector currentItemSets = (FastVector)this.m_Ls.elementAt(j);
            Enumeration enumItemSets = currentItemSets.elements();
            while (enumItemSets.hasMoreElements()) {
                AprioriItemSet currentItemSet = (AprioriItemSet)enumItemSets.nextElement();
                FastVector[] rules = currentItemSet.generateRulesBruteForce(this.m_minMetric, this.m_metricType, this.m_hashtables, j + 1, this.m_instances.numInstances(), this.m_significanceLevel);
                for (int k = 0; k < rules[0].size(); ++k) {
                    this.m_allTheRules[0].addElement(rules[0].elementAt(k));
                    this.m_allTheRules[1].addElement(rules[1].elementAt(k));
                    this.m_allTheRules[2].addElement(rules[2].elementAt(k));
                    this.m_allTheRules[3].addElement(rules[3].elementAt(k));
                    this.m_allTheRules[4].addElement(rules[4].elementAt(k));
                    this.m_allTheRules[5].addElement(rules[5].elementAt(k));
                }
            }
        }
    }

    private void findRulesQuickly() throws Exception {
        for (int j = 1; j < this.m_Ls.size(); ++j) {
            FastVector currentItemSets = (FastVector)this.m_Ls.elementAt(j);
            Enumeration enumItemSets = currentItemSets.elements();
            while (enumItemSets.hasMoreElements()) {
                AprioriItemSet currentItemSet = (AprioriItemSet)enumItemSets.nextElement();
                FastVector[] rules = currentItemSet.generateRules(this.m_minMetric, this.m_hashtables, j + 1);
                for (int k = 0; k < rules[0].size(); ++k) {
                    this.m_allTheRules[0].addElement(rules[0].elementAt(k));
                    this.m_allTheRules[1].addElement(rules[1].elementAt(k));
                    this.m_allTheRules[2].addElement(rules[2].elementAt(k));
                }
            }
        }
    }

    public static void main(String[] options) {
        StringBuffer text = new StringBuffer();
        Apriori apriori = new Apriori();
        try {
            text.append("\n\nApriori options:\n\n");
            text.append("-t <training file>\n");
            text.append("\tThe name of the training file.\n");
            Enumeration enu = apriori.listOptions();
            while (enu.hasMoreElements()) {
                Option option = (Option)enu.nextElement();
                text.append(option.synopsis() + '\n');
                text.append(option.description() + '\n');
            }
            String trainFileString = Utils.getOption((char)'t', (String[])options);
            if (trainFileString.length() == 0) {
                throw new Exception("No training file given!");
            }
            apriori.setOptions(options);
            BufferedReader reader = new BufferedReader(new FileReader(trainFileString));
            apriori.buildAssociations(new Instances((Reader)reader));
            System.out.println((Object)apriori);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\n" + e.getMessage() + text);
        }
    }
}

