/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.nn;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.learner.SerializableModel;
import edu.udo.cs.yale.operator.learner.nn.IdTrafo;
import edu.udo.cs.yale.operator.learner.nn.InputLayer;
import edu.udo.cs.yale.operator.learner.nn.Layer;
import edu.udo.cs.yale.operator.learner.nn.WeightedLayer;

public class NeuralNet
extends SerializableModel {
    private Layer inputLayer;
    private WeightedLayer[] layer;
    private double lambda;

    protected NeuralNet() {
    }

    public NeuralNet(Attribute label, int input, int hidden, int output, double lambda) {
        super(label);
        this.layer = new WeightedLayer[2];
        this.layer[1] = new WeightedLayer(hidden + 1, output, new IdTrafo(), null);
        this.layer[0] = new WeightedLayer(input + 1, hidden, new IdTrafo(), this.layer[1]);
        this.inputLayer = new InputLayer(input, null, this.layer[0]);
        this.lambda = lambda;
    }

    public double[] o(double[] in) {
        this.inputLayer.input(in);
        return this.layer[1].e();
    }

    public static double error(double[] t, double[] e) {
        double sum = 0.0;
        for (int i = 0; i < t.length; ++i) {
            double dif = e[i] - t[i];
            sum += dif * dif;
        }
        return sum / 2.0;
    }

    public void learn(double[] in, double[] t) {
        this.inputLayer.input(in);
        double[] e = this.layer[1].e();
        double[] u = this.layer[1].u();
        double[][] w = this.layer[1].weights();
        double[] s = this.layer[0].e();
        double[] delta = new double[this.layer[1].neurons() - 1];
        for (int p = 0; p < delta.length; ++p) {
            delta[p] = -(e[p] - t[p]) * this.layer[1].getTrafo().phiDerivation(u[p]);
            for (int q = 0; q < this.layer[0].neurons(); ++q) {
                double[] dArray = w[p];
                int n = q;
                dArray[n] = dArray[n] + this.lambda * delta[p] * s[q];
            }
        }
        double[] uSchlange = this.layer[0].u();
        double[][] wSchlange = this.layer[0].weights();
        double[] sSchlange = this.inputLayer.e();
        double[] deltaSchlange = new double[this.layer[0].neurons() - 1];
        for (int p = 0; p < deltaSchlange.length; ++p) {
            deltaSchlange[p] = 0.0;
            for (int i = 0; i < this.layer[1].neurons() - 1; ++i) {
                int n = p;
                deltaSchlange[n] = deltaSchlange[n] + delta[i] * w[i][p] * this.layer[1].getTrafo().phiDerivation(uSchlange[p]);
            }
            for (int q = 0; q < sSchlange.length; ++q) {
                double[] dArray = wSchlange[p];
                int n = q;
                dArray[n] = dArray[n] + this.lambda * deltaSchlange[p] * sSchlange[q];
            }
        }
    }

    public String toString() {
        String str = super.toString();
        if (this.inputLayer != null) {
            str = str + " [NeuralNet: " + this.inputLayer.neurons() + "/" + this.layer[0].neurons() + "/" + this.layer[1].neurons() + " neurons]";
        }
        return str;
    }

    public void apply(ExampleSet exampleSet) {
        ExampleReader r = exampleSet.getExampleReader();
        while (r.hasNext()) {
            Example example = r.next();
            double[] s = new double[example.getNumberOfAttributes()];
            for (int j = 0; j < s.length; ++j) {
                s[j] = example.getValue(j);
            }
            example.setPredictedLabel(this.o(s)[0]);
        }
    }
}

