/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.nn;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.learner.nn.NeuralNet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import java.util.List;

public class NNLearner
extends AbstractLearner {
    public NNLearner(OperatorDescription description) {
        super(description);
    }

    public Model learn(ExampleSet exampleSet) {
        int hiddenLayer = this.getParameterAsInt("hidden_layer");
        double lambda = this.getParameterAsDouble("lambda");
        NeuralNet nn = new NeuralNet(exampleSet.getLabel(), hiddenLayer, exampleSet.getNumberOfAttributes(), 1, lambda);
        ExampleReader i = exampleSet.getExampleReader();
        while (i.hasNext()) {
            Example e = i.next();
            double[] s = new double[e.getNumberOfAttributes()];
            for (int j = 0; j < s.length; ++j) {
                s[j] = e.getValue(j);
            }
            nn.learn(s, new double[]{e.getLabel()});
        }
        return nn;
    }

    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        return lc == LearnerCapability.NUMERICAL_CLASS;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt("hidden_layer", "Number of neurons in the hidden layer.", 0, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeDouble("lambda", "Parameter lambda.", 0.0, 1.0, 0.05));
        return types;
    }
}

