/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.nn;

import edu.udo.cs.yale.operator.learner.nn.Trafo;
import java.io.Serializable;

public abstract class Layer
implements Serializable {
    private Trafo trafo;
    private Layer succ;
    private double[] e;
    private double[] u;

    public Layer(int neurons, Trafo trafo, Layer succ) {
        this.succ = succ;
        this.trafo = trafo;
        this.e = new double[neurons + 1];
        this.u = new double[neurons + 1];
        if (trafo == null) {
            this.e = this.u;
        }
    }

    public abstract double[] calculate(double[] var1);

    public void input(double[] s) {
        double[] dummy = this.calculate(s);
        for (int i = 0; i < dummy.length; ++i) {
            this.u[i] = dummy[i];
            if (this.trafo == null) continue;
            this.e[i] = this.trafo.phi(this.u[i]);
        }
        this.u[this.e.length - 1] = 1.0;
        if (this.trafo != null) {
            this.e[this.e.length - 1] = this.trafo.phi(1.0);
        }
        if (this.succ != null) {
            this.succ.input(this.e);
        }
    }

    public int neurons() {
        return this.e.length;
    }

    public double[] e() {
        return this.e;
    }

    public double[] u() {
        return this.u;
    }

    public Trafo getTrafo() {
        return this.trafo;
    }
}

