/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.lazy;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.learner.lazy.DefaultModel;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.tools.LogService;
import java.util.Arrays;
import java.util.List;

public class DefaultLearner
extends AbstractLearner {
    private static final String[] METHODS = new String[]{"median", "average", "mode", "constant"};
    public static final int MEDIAN = 0;
    public static final int AVERAGE = 1;
    public static final int MODE = 2;
    public static final int CONSTANT = 3;

    public DefaultLearner(OperatorDescription description) {
        super(description);
    }

    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.POLYNOMINAL_CLASS) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        return lc == LearnerCapability.NUMERICAL_CLASS;
    }

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        double value = 0.0;
        double[] confidences = null;
        int method = this.getParameterAsInt("method");
        Attribute label = exampleSet.getLabel();
        if (label.isNominal() && (method == 0 || method == 1)) {
            LogService.logMessage(this.getName() + ": Cannot use method '" + METHODS[method] + "' for nominal labels: changing to 'mode'!", 4);
            method = 2;
        } else if (label.isNumerical() && method == 2) {
            LogService.logMessage(this.getName() + ": Cannot use method '" + METHODS[method] + "' for numerical labels: changing to 'average'!", 4);
            method = 1;
        }
        switch (method) {
            case 0: {
                double[] labels = new double[exampleSet.getSize()];
                ExampleReader r = exampleSet.getExampleReader();
                int counter = 0;
                while (r.hasNext()) {
                    Example example = r.next();
                    labels[counter++] = example.getLabel();
                }
                Arrays.sort(labels);
                value = labels[exampleSet.getSize() / 2];
                break;
            }
            case 1: {
                exampleSet.recalculateAttributeStatistics(label);
                value = label.getAverage();
                break;
            }
            case 2: {
                exampleSet.recalculateAttributeStatistics(label);
                value = label.mapString(label.getMode());
                confidences = new double[label.getNumberOfValues()];
                for (int i = 0; i < confidences.length; ++i) {
                    confidences[i] = (double)label.getValueCount(label.mapIndex(i + 0)) / (double)exampleSet.getSize();
                }
                break;
            }
            case 3: {
                value = this.getParameterAsDouble("constant");
                break;
            }
            default: {
                throw new OperatorException("DefaultLearner: Unknown default method '" + method + "'!");
            }
        }
        LogService.logMessage("Default value is '" + (label.isNominal() ? label.mapIndex((int)value) : value + "") + "'.", 2);
        return new DefaultModel(exampleSet.getLabel(), value, confidences);
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory("method", "The method to compute the default.", METHODS, 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("constant", "Value returned when method = constant.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        return types;
    }
}

