/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.operator.learner.kernel.evosvm.Individual;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class Population {
    private ArrayList individuals = new ArrayList();
    private Individual bestEver;
    private Individual currentBest;
    private int generations = 1;
    private int lastImprovement = 1;

    public void clear() {
        this.individuals.clear();
    }

    public void add(Individual individual) {
        this.individuals.add(individual);
    }

    public void addAll(Collection newIndividuals) {
        this.individuals.addAll(newIndividuals);
    }

    public void remove(Individual individual) {
        this.individuals.remove(individual);
    }

    public void remove(int i) {
        this.individuals.remove(i);
    }

    public Individual get(int i) {
        return (Individual)this.individuals.get(i);
    }

    public int getNumberOfIndividuals() {
        return this.individuals.size();
    }

    public void setCurrentBest(Individual currentBest) {
        this.currentBest = currentBest;
    }

    public Individual getCurrentBest() {
        return this.currentBest;
    }

    public void setBestEver(Individual bestEver) {
        this.lastImprovement = this.generations;
        this.bestEver = bestEver;
    }

    public Individual getBestEver() {
        return this.bestEver;
    }

    public void nextGeneration() {
        ++this.generations;
    }

    public int getGeneration() {
        return this.generations;
    }

    public int getGenerationsWithoutImprovement() {
        return this.generations - this.lastImprovement;
    }

    public void sort() {
        Collections.sort(this.individuals);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Population in generation " + this.generations + ":\n");
        Iterator i = this.individuals.iterator();
        while (i.hasNext()) {
            result.append(i.next() + "\n");
        }
        return result.toString();
    }
}

