/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.operator.learner.kernel.evosvm.Individual;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Population;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.PopulationOperator;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.Random;

public class Mutation
implements PopulationOperator {
    private double c;
    private double variance;
    private Random random;

    public Mutation(double variance, double c) {
        this.c = c;
        this.variance = variance;
        this.random = RandomGenerator.getGlobalRandomGenerator();
    }

    public void setVariance(double variance) {
        this.variance = variance;
    }

    public double getVariance() {
        return this.variance;
    }

    public void operate(Population population) {
        LinkedList<Individual> newIndividuals = new LinkedList<Individual>();
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            Individual clone = (Individual)population.get(i).clone();
            double[] alphas = clone.getAlphas();
            for (int j = 0; j < alphas.length; ++j) {
                int n = j;
                alphas[n] = alphas[n] + this.random.nextGaussian() * this.variance;
                if (alphas[j] > this.c) {
                    alphas[j] = this.c;
                }
                if (!(alphas[j] < 0.0)) continue;
                alphas[j] = 0.0;
            }
            clone.setAlphas(alphas);
            newIndividuals.add(clone);
        }
        population.clear();
        population.addAll(newIndividuals);
    }
}

