/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.EvoOptimization;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Kernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.PolynomialKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.RBFKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.SigmoidKernel;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import java.util.List;

public class EvoSVM
extends AbstractLearner {
    private Kernel kernel;

    public EvoSVM(OperatorDescription description) {
        super(description);
    }

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        int kernelType = this.getParameterAsInt("kernel_type");
        Kernel kernel = Kernel.createKernel(kernelType);
        if (kernelType == 1) {
            double sigma = this.getParameterAsDouble("kernel_sigma");
            if (sigma == 0.0) {
                sigma = 1.0 / (double)exampleSet.getNumberOfAttributes();
            }
            ((RBFKernel)kernel).setSigma(sigma);
        } else if (kernelType == 2) {
            ((PolynomialKernel)kernel).setPolynomialParameters(this.getParameterAsInt("kernel_degree"), this.getParameterAsDouble("kernel_shift"));
        } else if (kernelType == 3) {
            ((SigmoidKernel)kernel).setSigmoidParameters(this.getParameterAsDouble("kernel_a"), this.getParameterAsDouble("kernel_b"));
        }
        EvoOptimization optimization = new EvoOptimization(exampleSet, kernel, this.getParameterAsDouble("C"), this.getParameterAsInt("max_evaluations"), this.getParameterAsInt("generations_without_improval"), this.getParameterAsInt("population_size"), this.getParameterAsDouble("crossover_prob"), this.getParameterAsDouble("mutation_sigma"), this.getParameterAsDouble("tournament_fraction"), this.getParameterAsBoolean("keep_best"), this.getParameterAsBoolean("show_convergence_plot"));
        return optimization.train();
    }

    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        return lc == LearnerCapability.BINOMINAL_CLASS;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("show_convergence_plot", "Indicates if a dialog with a convergence plot should be drawn.", false));
        ParameterTypeSingle type = new ParameterTypeCategory("kernel_type", "The SVM kernel type", Kernel.KERNEL_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_sigma", "The SVM kernel parameter sigma (radial kernel, 0 means sigma = 1 / #atts).", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("kernel_degree", "The SVM kernel parameter degree (polynomial).", 0, Integer.MAX_VALUE, 3);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_shift", "The SVM kernel parameter shift (polynomial).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_a", "The SVM kernel parameter a (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_b", "The SVM kernel parameter b (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("C", "The SVM complexity constant (0: calculates probably good value).", 0.0, Double.POSITIVE_INFINITY, 0.0);
        types.add(type);
        types.add(new ParameterTypeInt("max_evaluations", "Stop after this many evaluations", 1, Integer.MAX_VALUE, 5000));
        types.add(new ParameterTypeInt("generations_without_improval", "Stop after this number of generations without improvement (-1: optimize until max_iterations).", -1, Integer.MAX_VALUE, 50));
        types.add(new ParameterTypeInt("population_size", "The population size (-1: number of examples)", -1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeDouble("crossover_prob", "The probability for crossover.", 0.0, 1.0, 1.0));
        types.add(new ParameterTypeDouble("mutation_sigma", "The standard deviation for the mutation (-1: sigma = C/10).", -1.0, Double.POSITIVE_INFINITY, -1.0));
        types.add(new ParameterTypeDouble("tournament_fraction", "The fraction of the population used for tournament selection.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean("keep_best", "Indicates if the best individual should survive (elititst selection).", true));
        return types;
    }
}

