/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.FastExample2SparseTransform;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.learner.kernel.LibSVMModel;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;
import libsvm.svm;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_problem;

public class LibSVMLearner
extends AbstractLearner {
    public static final String[] SVM_TYPES = new String[]{"C-SVC", "nu-SVC", "one-class", "epsilon-SVR", "nu-SVR"};
    public static final String[] KERNEL_TYPES = new String[]{"linear", "poly", "rbf", "sigmoid"};

    public LibSVMLearner(OperatorDescription description) {
        super(description);
    }

    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        if (lc == LearnerCapability.POLYNOMINAL_CLASS) {
            return true;
        }
        return lc == LearnerCapability.NUMERICAL_CLASS;
    }

    protected static svm_node[] makeNodes(Example e, FastExample2SparseTransform ripper) {
        int[] nonDefaultIndices = ripper.getNonDefaultAttributeIndices(e);
        double[] nonDefaultValues = ripper.getNonDefaultAttributeValues(e, nonDefaultIndices);
        svm_node[] nodeArray = new svm_node[nonDefaultIndices.length];
        for (int a = 0; a < nonDefaultIndices.length; ++a) {
            svm_node node = new svm_node();
            node.index = nonDefaultIndices[a];
            node.value = nonDefaultValues[a];
            nodeArray[a] = node;
        }
        return nodeArray;
    }

    private svm_problem getProblem(ExampleSet exampleSet) {
        LogService.logMessage("Creating LibSVM problem.", 0);
        FastExample2SparseTransform ripper = new FastExample2SparseTransform(exampleSet);
        int nodeCount = 0;
        svm_problem problem = new svm_problem();
        problem.l = exampleSet.getSize();
        problem.y = new double[exampleSet.getSize()];
        problem.x = new svm_node[exampleSet.getSize()][];
        ExampleReader i = exampleSet.getExampleReader();
        int j = 0;
        while (i.hasNext()) {
            Example e = i.next();
            problem.x[j] = LibSVMLearner.makeNodes(e, ripper);
            problem.y[j] = e.getLabel();
            nodeCount += problem.x[j].length;
            ++j;
        }
        LogService.logMessage("Created " + nodeCount + " nodes for " + j + " examples.", 2);
        return problem;
    }

    private svm_parameter getParameters(ExampleSet exampleSet) {
        svm_parameter params = new svm_parameter();
        params.svm_type = this.getParameterAsInt("svm_type");
        params.kernel_type = this.getParameterAsInt("kernel_type");
        params.degree = this.getParameterAsDouble("degree");
        params.gamma = this.getParameterAsDouble("gamma");
        if (params.gamma == 0.0) {
            params.gamma = 1.0 / (double)exampleSet.getSize();
        }
        params.coef0 = this.getParameterAsDouble("coef0");
        params.nu = this.getParameterAsDouble("nu");
        params.cache_size = this.getParameterAsInt("cache_size");
        params.C = this.getParameterAsDouble("C");
        params.eps = this.getParameterAsDouble("epsilon");
        params.p = this.getParameterAsDouble("p");
        params.shrinking = this.getParameterAsBoolean("shrinking") ? 1 : 0;
        params.probability = 1;
        return params;
    }

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        svm_parameter params = this.getParameters(exampleSet);
        svm_problem problem = this.getProblem(exampleSet);
        String errorMsg = svm.svm_check_parameter(problem, params);
        if (errorMsg != null) {
            throw new UserError((Operator)this, 905, new Object[]{"libsvm", errorMsg});
        }
        LogService.logMessage("Training LibSVM.", 0);
        return new LibSVMModel(exampleSet.getLabel(), svm.svm_train(problem, params));
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory("svm_type", "SVM for classification (C-SVC, nu-SVC), regression (epsilon-SVR, nu-SVR) and distribution estimation (one-class)", SVM_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory("kernel_type", "The type of the kernel functions", KERNEL_TYPES, 2);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("degree", "The degree for a polynomial kernel function.", 1.0, Double.POSITIVE_INFINITY, 3.0));
        types.add(new ParameterTypeDouble("gamma", "The parameter gamma for polynomial, rbf, and sigmoid kernel functions (0 means 1/#attributes).", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble("coef0", "The parameter coef0 for polynomial and sigmoid kernel functions.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        type = new ParameterTypeDouble("C", "The cost parameter C for c_svc, epsilon_svr, and nu_svr.", 1.0E-15, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("nu", "The parameter nu for nu_svc, one_class, and nu_svr.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.5));
        types.add(new ParameterTypeInt("cache_size", "Cache size in Megabyte.", 0, Integer.MAX_VALUE, 80));
        types.add(new ParameterTypeDouble("epsilon", "Tolerance of termination criterion.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.001));
        types.add(new ParameterTypeDouble("p", "Tolerance of loss function of epsilon-SVR.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.1));
        types.add(new ParameterTypeBoolean("shrinking", "Whether to use the shrinking heuristics.", true));
        return types;
    }
}

