/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.operator.learner.IOModel;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.TempFileService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;

public abstract class FileModel
extends IOModel {
    private byte[] data;

    public FileModel(Attribute label) {
        super(label);
        this.data = new byte[0];
    }

    public FileModel(Attribute label, byte[] data) {
        super(label);
        this.data = data;
    }

    public FileModel(Attribute label, File modelFile) throws IOException {
        super(label);
        if (!modelFile.exists()) {
            throw new FileNotFoundException("Model file does not exist: " + modelFile);
        }
        FileInputStream in = new FileInputStream(modelFile);
        this.data = new byte[(int)modelFile.length()];
        in.read(this.data);
        in.close();
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        this.writeYaleData(out);
        out.flush();
        this.writeFileData(out);
        out.flush();
    }

    public final void readData(ObjectInputStream in) throws IOException {
        this.readYaleData(in);
        this.readFileData(in);
    }

    public abstract void writeYaleData(ObjectOutputStream var1) throws IOException;

    public abstract void readYaleData(ObjectInputStream var1) throws IOException;

    private void readFileData(ObjectInputStream in) throws IOException {
        this.data = new byte[in.readInt()];
        in.readFully(this.data);
        LogService.logMessage("Model has " + this.data.length + " bytes.", 0);
    }

    private void writeFileData(ObjectOutputStream out) throws IOException {
        out.writeInt(this.data.length);
        out.write(this.data);
        out.flush();
    }

    public File writeModelToTmp() throws IOException {
        File file = TempFileService.createTempFile("model_");
        FileOutputStream out = new FileOutputStream(file);
        ((OutputStream)out).write(this.data);
        ((OutputStream)out).close();
        return file;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public Reader getReader() {
        return new InputStreamReader(this.getInputStream());
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        FileModel other = (FileModel)o;
        if (this.data.length != other.data.length) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == other.data[i]) continue;
            return false;
        }
        return true;
    }
}

