/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.io.ResultSetExampleSource;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.tools.LogService;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.List;
import org.kobjects.jdbc.TableManager;
import org.kobjects.jdbc.util.AbstractResultSet;

public abstract class KDBExampleSource
extends ResultSetExampleSource {
    public abstract String getFormat();

    public KDBExampleSource(OperatorDescription description) {
        super(description);
    }

    public ResultSet getResultSet() {
        String dataFile = this.getParameterAsString("data_file");
        String dataFileAbsolutePath = this.getExperiment().resolveFileName(dataFile).getAbsolutePath();
        return TableManager.getResultSet((String)(this.getFormat() + ":" + dataFileAbsolutePath), (int)1);
    }

    public void setNominalValues(List attributeList, ResultSet resultSet, Attribute label) {
        if (resultSet instanceof AbstractResultSet) {
            AbstractResultSet ars = (AbstractResultSet)resultSet;
            Iterator i = attributeList.iterator();
            int j = 0;
            while (i.hasNext()) {
                Attribute attribute = (Attribute)i.next();
                Object[] values = ars.getColumnSet().getColumn(++j).getValues();
                if (!attribute.isNominal()) continue;
                if (values == null) {
                    LogService.logMessage("Information about class values is null!", 4);
                    continue;
                }
                for (int k = 0; k < values.length; ++k) {
                    attribute.mapString(values[k].toString());
                }
            }
        } else {
            LogService.logMessage("Result set does not provide information about class values!", 4);
        }
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeFile("data_file", "The file containing the data", false));
        return types;
    }
}

