/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.SparseMapDataRow;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class MassiveDataGenerator
extends Operator {
    private static final int NUMBER_OF_ATTRIBUTES = 5;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public MassiveDataGenerator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt("number_examples");
        int numberOfAttributes = this.getParameterAsInt("number_attributes");
        double sparseFraction = this.getParameterAsDouble("sparse_fraction");
        boolean sparseRepresentation = this.getParameterAsBoolean("sparse_representation");
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int m = 0; m < numberOfAttributes; ++m) {
            attributes.add(AttributeFactory.createAttribute("att" + (m + 1), 4));
        }
        Attribute label = AttributeFactory.createAttribute("label", 1);
        label.mapString("positive");
        label.mapString("negative");
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        LinkedList data = new LinkedList();
        for (int n = 0; n < numberOfExamples; ++n) {
            double value;
            int i;
            Object dataRow;
            int counter = 0;
            if (sparseRepresentation) {
                dataRow = new SparseMapDataRow();
                for (i = 0; i < numberOfAttributes; ++i) {
                    value = RandomGenerator.getGlobalRandomGenerator().nextDouble() > sparseFraction ? 1.0 : 0.0;
                    ((SparseMapDataRow)dataRow).set((Attribute)attributes.get(i), value);
                    if (value != 0.0) continue;
                    ++counter;
                }
                if ((double)counter < sparseFraction * (double)numberOfAttributes) {
                    ((SparseMapDataRow)dataRow).set(label, label.mapString("positive"));
                } else {
                    ((SparseMapDataRow)dataRow).set(label, label.mapString("negative"));
                }
                table.addDataRow((DataRow)dataRow);
                continue;
            }
            dataRow = new double[numberOfAttributes + 1];
            for (i = 0; i < numberOfAttributes; ++i) {
                value = RandomGenerator.getGlobalRandomGenerator().nextDouble() > sparseFraction ? 1.0 : 0.0;
                dataRow[i] = value;
                if (value != 0.0) continue;
                ++counter;
            }
            dataRow[((Object)dataRow).length - 1] = (double)counter < sparseFraction * (double)numberOfAttributes ? (Object)label.mapString("positive") : (Object)label.mapString("negative");
            table.addDataRow(new DoubleArrayDataRow((double[])dataRow));
        }
        ExampleSet result = table.createCompleteExampleSet(label, null, null, null);
        return new IOObject[]{result};
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = MassiveDataGenerator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("number_examples", "The number of generated examples.", 0, Integer.MAX_VALUE, 10000);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("number_attributes", "The number of attributes.", 0, Integer.MAX_VALUE, 10000);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("sparse_fraction", "The fraction of default attributes.", 0.0, 1.0, 0.99));
        types.add(new ParameterTypeBoolean("sparse_representation", "Indicates if the example should be internally represented in a sparse format.", true));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

