/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class WeightingMutation
extends IndividualOperator {
    private double variance;
    private boolean bounded;
    private Random random;

    public WeightingMutation(double variance, boolean bounded) {
        this.variance = variance;
        this.bounded = bounded;
        this.random = RandomGenerator.getGlobalRandomGenerator();
    }

    public void setVariance(double variance) {
        this.variance = variance;
    }

    public double getVariance() {
        return this.variance;
    }

    public List operate(AttributeWeightedExampleSet exampleSet) {
        LinkedList<AttributeWeightedExampleSet> l = new LinkedList<AttributeWeightedExampleSet>();
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)exampleSet.clone();
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            Attribute attribute = exampleSet.getAttribute(i);
            double weight = exampleSet.getWeight(i);
            weight += this.random.nextGaussian() * this.variance;
            if (this.bounded && (!(weight >= 0.0) || !(weight <= 1.0))) continue;
            exampleSet.setWeightForBlock(attribute, weight);
        }
        if (exampleSet.getNumberOfUsedAttributes() > 0) {
            l.add(exampleSet);
        }
        return l;
    }
}

