/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.SimplePlotterDialog;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import java.util.List;

public class StandardDeviationWeighting
extends Operator {
    private static final String[] NORMALIZATIONS = new String[]{"none", "average", "minimum", "maximum"};
    private static final int NONE = 0;
    private static final int AVERAGE = 1;
    private static final int MINIMUM = 2;
    private static final int MAXIMUM = 3;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$AttributeWeights;

    public StandardDeviationWeighting(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = StandardDeviationWeighting.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        exampleSet.recalculateAllAttributeStatistics();
        int normalization = this.getParameterAsInt("normalize");
        Statistics stats = new Statistics("Standard Deviation Plot");
        stats.init(new String[]{"Attribute index", "StandardDeviation/" + NORMALIZATIONS[normalization]});
        AttributeWeights weights = new AttributeWeights();
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            Attribute attribute = exampleSet.getAttribute(i);
            double data = Math.sqrt(attribute.getVariance());
            switch (normalization) {
                case 1: {
                    data /= attribute.getAverage();
                    break;
                }
                case 2: {
                    data /= attribute.getMinimum();
                    break;
                }
                case 3: {
                    data /= attribute.getMaximum();
                    break;
                }
            }
            data = Math.abs(data);
            stats.add(new Object[]{new Double(i), new Double(data)});
            weights.setWeight(attribute.getName(), data);
        }
        if (this.getParameterAsBoolean("create_plot")) {
            SimplePlotterDialog plotter = new SimplePlotterDialog(stats);
            plotter.setXAxis(0);
            plotter.plotColumn(1, true);
            plotter.setVisible(true);
        }
        if (this.getParameterAsBoolean("create_weights")) {
            return new IOObject[]{exampleSet, weights};
        }
        return new IOObject[]{exampleSet};
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = StandardDeviationWeighting.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        if (this.getParameterAsBoolean("create_weights")) {
            return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = StandardDeviationWeighting.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet, class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = StandardDeviationWeighting.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights};
        }
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = StandardDeviationWeighting.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory("normalize", "Indicates if the standard deviation should be dividey by the minimum, maximum, or average of the attribute.", NORMALIZATIONS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean("create_plot", "Indicates if a plot with the standard deviations should be created.", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean("create_weights", "Indicates if attribute weights should be created based on the standard deviation values for the attributes.", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

