/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.ga;

import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.List;

public class SelectionMutation
extends IndividualOperator {
    private double probability;

    public SelectionMutation(double probability) {
        this.probability = probability;
    }

    public List operate(AttributeWeightedExampleSet es) {
        LinkedList<AttributeWeightedExampleSet> l = new LinkedList<AttributeWeightedExampleSet>();
        AttributeWeightedExampleSet exampleSet = es;
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)es.clone();
        double prob = this.probability < 0.0 ? 1.0 / (double)clone.getNumberOfAttributes() : this.probability;
        for (int i = 0; i < clone.getNumberOfAttributes(); ++i) {
            if (!(RandomGenerator.getGlobalRandomGenerator().nextDouble() < prob)) continue;
            i = clone.flipAttributeUsed(i);
        }
        if (clone.getNumberOfUsedAttributes() > 0) {
            l.add(clone);
        } else {
            l.add(exampleSet);
        }
        return l;
    }
}

