/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.ga;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.generator.SinusFactory;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FourierGeneratingMutation
extends IndividualOperator {
    private List generators;
    private List originalAttributes;
    private double p;
    private int numberOfConstructed;
    private int numberOfOriginal;
    private SinusFactory factory = null;
    private int maxDepth;
    private String[] unusableFunctions = new String[0];
    private RandomGenerator random = RandomGenerator.getGlobalRandomGenerator();

    public FourierGeneratingMutation(List originalAttributes, double p, List generators, int numberOfConstructed, int numberOfOriginal, int maxPeaks, int adaptionType, int attributesPerPeak, double epsilon, int maxDepth, String[] unusableFunctions) {
        this.originalAttributes = originalAttributes;
        this.p = p;
        this.generators = generators;
        this.numberOfConstructed = numberOfConstructed;
        this.numberOfOriginal = numberOfOriginal;
        this.factory = new SinusFactory(maxPeaks);
        this.factory.setAdaptionType(adaptionType);
        this.factory.setEpsilon(epsilon);
        this.factory.setAttributePerPeak(attributesPerPeak);
        this.maxDepth = maxDepth;
        this.unusableFunctions = unusableFunctions;
    }

    public List operate(AttributeWeightedExampleSet exampleSet) throws Exception {
        LinkedList<AttributeWeightedExampleSet> l = new LinkedList<AttributeWeightedExampleSet>();
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)exampleSet.clone();
        try {
            int numberOriginal = this.addOriginalAttribute(clone);
            int numberCreated = this.addGeneratedAttribute(clone);
            this.deselect(clone, numberOriginal + numberCreated);
        }
        catch (GenerationException e) {
            LogService.logMessage("GeneratingMutation: Exception occured during generation of attributes, using original example set instead.", 4);
            l.add(exampleSet);
        }
        if (clone.getNumberOfUsedAttributes() > 0) {
            Iterator i = exampleSet.getUserDataKeys().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                clone.setUserData(key, exampleSet.getUserData(key));
            }
            l.add(clone);
        } else {
            l.add(exampleSet);
        }
        return l;
    }

    private int addGeneratedAttribute(AttributeWeightedExampleSet exampleSet) throws OperatorException {
        int counter = 0;
        for (int k = 0; k < this.numberOfConstructed; ++k) {
            FeatureGenerator generator;
            if (!(this.random.nextDouble() < this.p) || (generator = FeatureGenerator.selectGenerator(exampleSet, this.generators, this.maxDepth, this.unusableFunctions)) == null) continue;
            generator = generator.newInstance();
            Attribute[] args = Tools.getRandomCompatibleAttributes(exampleSet, generator, this.maxDepth, this.unusableFunctions);
            generator.setArguments(args);
            LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
            generatorList.add(generator);
            List newAttributes = FeatureGenerator.generateAll(exampleSet.getExampleTable(), generatorList);
            exampleSet.addAllAttributes(newAttributes);
            counter += newAttributes.size();
            Iterator i = newAttributes.iterator();
            LinkedList sinAttributes = new LinkedList();
            Attribute label = exampleSet.getLabel();
            while (i.hasNext()) {
                Attribute current = (Attribute)i.next();
                if (current.isNominal() || current.getConstructionDescription().indexOf("sin") != -1) continue;
                List peaks = this.factory.getAttributePeaks(exampleSet, label, current);
                sinAttributes.addAll(peaks);
            }
            if (sinAttributes.size() > 0) {
                this.factory.generateSinusFunctions(exampleSet, sinAttributes);
            }
            counter += sinAttributes.size();
        }
        return counter;
    }

    private int addOriginalAttribute(AttributeWeightedExampleSet exampleSet) throws GenerationException, OperatorException {
        int counter = 0;
        for (int k = 0; k < this.numberOfOriginal; ++k) {
            List peaks;
            if (!(this.random.nextDouble() < this.p)) continue;
            int i = this.random.nextInt(this.originalAttributes.size());
            Attribute originalAttribute = (Attribute)this.originalAttributes.get(i);
            if (exampleSet.getAttribute(originalAttribute.getName()) == null) {
                exampleSet.addAttribute(originalAttribute);
                ++counter;
            }
            if ((peaks = this.factory.getAttributePeaks(exampleSet, exampleSet.getLabel(), originalAttribute)).size() > 0) {
                this.factory.generateSinusFunctions(exampleSet, peaks);
            }
            counter += peaks.size();
        }
        return counter;
    }

    private void deselect(AttributeWeightedExampleSet exampleSet, int m) {
        int n = exampleSet.getNumberOfAttributes();
        for (int i = n - 1; i >= 0; --i) {
            if (!(this.random.nextDouble() < (double)m * (this.p / (double)exampleSet.getNumberOfAttributes()))) continue;
            exampleSet.removeAttribute(i);
        }
    }
}

