/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.BasicArithmeticOperationGenerator;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.generator.ReciprocalValueGenerator;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.features.FeatureSelectionOperator;
import edu.udo.cs.yale.operator.features.KeepBest;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.RedundanceRemoval;
import edu.udo.cs.yale.operator.features.SwitchingForwardSelection;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class GeneratingForwardSelection
extends FeatureSelectionOperator {
    private Attribute[] originalAttributes;
    private ExampleSet bestIndividual;
    private List useGenerators;
    private int newAttributeStart;
    private int turn;

    public GeneratingForwardSelection(OperatorDescription description) {
        super(description);
        this.addValue(new Value("turn", "The number of the current turn."){

            public double getValue() {
                return GeneratingForwardSelection.this.turn;
            }
        });
    }

    public IOObject[] apply() throws OperatorException {
        FeatureGenerator g;
        this.newAttributeStart = 0;
        this.turn = 0;
        this.bestIndividual = null;
        this.originalAttributes = null;
        this.useGenerators = new LinkedList();
        if (this.getParameterAsBoolean("reciprocal_value")) {
            g = new ReciprocalValueGenerator();
            this.useGenerators.add(g);
        }
        if (this.getParameterAsBoolean("use_plus")) {
            g = new BasicArithmeticOperationGenerator(0);
            this.useGenerators.add(g);
        }
        if (this.getParameterAsBoolean("use_diff")) {
            g = new BasicArithmeticOperationGenerator(1);
            this.useGenerators.add(g);
        }
        if (this.getParameterAsBoolean("use_mult")) {
            g = new BasicArithmeticOperationGenerator(2);
            this.useGenerators.add(g);
        }
        if (this.getParameterAsBoolean("use_div")) {
            g = new BasicArithmeticOperationGenerator(3);
            this.useGenerators.add(g);
        }
        if (this.useGenerators.size() == 0) {
            LogService.logMessage("No FeatureGenerators specified for " + this.getName() + ".", 4);
        }
        if (this.getParameterAsBoolean("restrictive_selection")) {
            FeatureGenerator.setSelectionMode(FeatureGenerator.SELECTION_MODE_RESTRICTIVE);
        } else {
            FeatureGenerator.setSelectionMode(FeatureGenerator.SELECTION_MODE_ALL);
        }
        return super.apply();
    }

    public Population createInitialPopulation(ExampleSet es) {
        int i;
        this.originalAttributes = new Attribute[es.getNumberOfAttributes()];
        for (int i2 = 0; i2 < this.originalAttributes.length; ++i2) {
            this.originalAttributes[i2] = es.getAttribute(i2);
        }
        Population initP = new Population();
        AttributeWeightedExampleSet nes = new AttributeWeightedExampleSet((ExampleSet)es.clone());
        for (i = 0; i < es.getNumberOfAttributes(); ++i) {
            nes.setAttributeUsed(es.getAttribute(i), false);
        }
        for (i = 0; i < es.getNumberOfAttributes(); ++i) {
            AttributeWeightedExampleSet forwardES = (AttributeWeightedExampleSet)nes.clone();
            forwardES.setAttributeUsed(es.getAttribute(i), true);
            initP.add(forwardES);
        }
        return initP;
    }

    public List getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        LinkedList<PopulationOperator> preOp = new LinkedList<PopulationOperator>();
        preOp.add(new KeepBest(this.getParameterAsInt("keep_best")));
        preOp.add(new SwitchingForwardSelection());
        preOp.add(new RedundanceRemoval());
        return preOp;
    }

    public boolean solutionGoodEnough(Population pop) throws OperatorException {
        if (super.solutionGoodEnough(pop)) {
            AttributeWeightedExampleSet fsBest = (AttributeWeightedExampleSet)pop.bestEver().clone();
            if (this.bestIndividual == null || ((PerformanceVector)fsBest.getUserData("performance")).compareTo((PerformanceVector)this.bestIndividual.getUserData("performance")) > 0) {
                ++this.turn;
                this.bestIndividual = (ExampleSet)fsBest.clone();
                fsBest = new AttributeWeightedExampleSet(fsBest.createCleanExampleSet());
                LogService.logMessage(this.getName() + ": " + Tools.ordinalNumber(this.turn) + " turn's FS result: " + fsBest, 2);
                LinkedList<FeatureGenerator> generators = new LinkedList<FeatureGenerator>();
                ListIterator i = this.useGenerators.listIterator();
                while (i.hasNext()) {
                    int a;
                    FeatureGenerator fg = (FeatureGenerator)i.next();
                    if (fg.getInputAttributes().length == 2) {
                        for (a = this.newAttributeStart; a < fsBest.getNumberOfAttributes(); ++a) {
                            for (int o = 0; o < this.originalAttributes.length; ++o) {
                                FeatureGenerator g = fg.newInstance();
                                g.setArguments(new Attribute[]{this.originalAttributes[o], fsBest.getAttribute(a)});
                                generators.add(g);
                            }
                        }
                        continue;
                    }
                    if (fg.getInputAttributes().length == 1) {
                        for (a = 0; a < fsBest.getNumberOfAttributes(); ++a) {
                            FeatureGenerator g = fg.newInstance();
                            g.setArguments(new Attribute[]{fsBest.getAttribute(a)});
                            generators.add(g);
                        }
                        continue;
                    }
                    LogService.logMessage(this.getName() + ": functions with arity " + fg.getInputAttributes().length + " not supported: " + fg, 4);
                }
                LogService.logMessage(this.getName() + ": generating " + generators.size() + " new attributes.", 2);
                this.newAttributeStart = fsBest.getNumberOfAttributes();
                try {
                    List attributes = FeatureGenerator.generateAll(fsBest.getExampleTable(), generators);
                    Iterator j = attributes.iterator();
                    while (j.hasNext()) {
                        Attribute attr = (Attribute)j.next();
                        try {
                            fsBest.addAttribute(attr);
                            fsBest.setAttributeUsed(attr, false);
                        }
                        catch (Exception e) {
                            LogService.logMessage(this.getName() + ": " + e.getMessage(), 4);
                        }
                    }
                }
                catch (GenerationException e) {
                    throw new UserError((Operator)this, (Throwable)e, 108, (Object)e.getMessage());
                }
                pop.clear();
                pop.add(fsBest);
                return false;
            }
            return true;
        }
        return false;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("reciprocal_value", "Generate reciprocal values.", true));
        types.add(new ParameterTypeBoolean("use_plus", "Generate sums.", true));
        types.add(new ParameterTypeBoolean("use_diff", "Generate differences.", true));
        types.add(new ParameterTypeBoolean("use_mult", "Generate products.", true));
        types.add(new ParameterTypeBoolean("use_div", "Generate quotients.", true));
        types.add(new ParameterTypeBoolean("restrictive_selection", "Use restrictive generator selection (faster).", true));
        return types;
    }
}

