/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.generator.SinusFactory;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import java.util.LinkedList;
import java.util.List;

public class FourierGenerator
extends IndividualOperator {
    private SinusFactory factory = null;
    private int startGenerations = 0;
    private int applyInGeneration = 1;

    public FourierGenerator(int maxPeaks, int adaptionType, int attributesPerPeak, double epsilon) {
        this.factory = new SinusFactory(maxPeaks);
        this.factory.setAdaptionType(adaptionType);
        this.factory.setEpsilon(epsilon);
        this.factory.setAttributePerPeak(attributesPerPeak);
    }

    public void setStartGenerations(int startGenerations) {
        this.startGenerations = startGenerations;
    }

    public void setApplyInGeneration(int applyInGeneration) {
        this.applyInGeneration = applyInGeneration;
    }

    public boolean performOperation(int generation) {
        return generation <= this.startGenerations || this.applyInGeneration != 0 && generation % this.applyInGeneration == 0;
    }

    public List operate(AttributeWeightedExampleSet exampleSet) throws Exception {
        Attribute label = exampleSet.getLabel();
        LinkedList attributes = new LinkedList();
        double totalMaxEvidence = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            Attribute current = exampleSet.getAttribute(i);
            if (current.isNominal() || current.getConstructionDescription().indexOf("sin") != -1) continue;
            List peaks = this.factory.getAttributePeaks(exampleSet, label, current);
            attributes.addAll(peaks);
        }
        if (attributes.size() > 0) {
            this.factory.generateSinusFunctions(exampleSet, attributes);
        }
        LinkedList<AttributeWeightedExampleSet> result = new LinkedList<AttributeWeightedExampleSet>();
        result.add(exampleSet);
        return result;
    }
}

