/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features;

import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.BackwardElimination;
import edu.udo.cs.yale.operator.features.FeatureOperator;
import edu.udo.cs.yale.operator.features.ForwardSelection;
import edu.udo.cs.yale.operator.features.KeepBest;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.RedundanceRemoval;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import java.util.LinkedList;
import java.util.List;

public class FeatureSelectionOperator
extends FeatureOperator {
    public static final int FORWARD_SELECTION = 0;
    public static final int BACKWARD_ELIMINATION = 1;
    private static final String[] DIRECTIONS = new String[]{"forward", "backward"};
    private int generationsWOImp;
    private int maxGenerations;

    public FeatureSelectionOperator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        this.maxGenerations = this.getParameterAsInt("maximum_number_of_generations");
        this.generationsWOImp = this.getParameterAsInt("generations_without_improval");
        return super.apply();
    }

    int getDefaultDirection() {
        return 0;
    }

    public Population createInitialPopulation(ExampleSet es) {
        int direction = this.getParameterAsInt("selection_direction");
        Population initP = new Population();
        if (direction == 0) {
            int i;
            AttributeWeightedExampleSet nes = new AttributeWeightedExampleSet((ExampleSet)es.clone());
            for (i = 0; i < es.getNumberOfAttributes(); ++i) {
                nes.removeAttribute(es.getAttribute(i));
            }
            for (i = 0; i < es.getNumberOfAttributes(); ++i) {
                AttributeWeightedExampleSet forwardES = (AttributeWeightedExampleSet)nes.clone();
                forwardES.addAttribute(es.getAttribute(i));
                if (forwardES.getNumberOfUsedAttributes() <= 0) continue;
                initP.add(forwardES);
            }
        } else {
            AttributeWeightedExampleSet nes = new AttributeWeightedExampleSet((ExampleSet)es.clone());
            for (int i = 0; i < nes.getNumberOfAttributes(); ++i) {
                nes.setAttributeUsed(i, true);
            }
            if (nes.getNumberOfUsedAttributes() > 0) {
                initP.add(nes);
            }
        }
        return initP;
    }

    public List getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        int direction = this.getParameterAsInt("selection_direction");
        int keepBest = this.getParameterAsInt("keep_best");
        LinkedList<PopulationOperator> preOp = new LinkedList<PopulationOperator>();
        preOp.add(new KeepBest(keepBest));
        if (direction == 0) {
            preOp.add(new ForwardSelection(input));
            this.maxGenerations = this.maxGenerations <= 0 ? input.getNumberOfAttributes() - 1 : --this.maxGenerations;
        } else {
            preOp.add(new BackwardElimination());
            if (this.maxGenerations <= 0) {
                this.maxGenerations = input.getNumberOfAttributes();
            }
        }
        preOp.add(new RedundanceRemoval());
        return preOp;
    }

    public List getPostEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList();
    }

    public boolean solutionGoodEnough(Population pop) throws OperatorException {
        return pop.empty() || this.generationsWOImp > 0 && pop.getGenerationsWithoutImproval() >= this.generationsWOImp || pop.getGeneration() >= this.maxGenerations;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory("selection_direction", "Forward selection or backward elimination.", DIRECTIONS, this.getDefaultDirection());
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt("keep_best", "Keep the best n individuals in each generation.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt("generations_without_improval", "Stop after n generations without improval of the performance (-1: stops if the maximum_number_of_generations is reached).", -1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt("maximum_number_of_generations", "Delivers the maximum amount of generations (-1: might use or deselect all features).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

