/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Image;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.imageio.ImageIO;

public final class OperatorDescription
implements Comparable {
    private String name;
    private Class clazz;
    private String description;
    private String group;
    private Image icon = null;
    private String iconName;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$OperatorDescription;

    public OperatorDescription(ClassLoader classLoader, String name, String className, String description, String group, String icon) throws ClassNotFoundException {
        this.name = name;
        this.clazz = Class.forName(className, true, classLoader);
        this.description = description;
        this.group = group;
        URL url = null;
        if (icon != null && icon.length() > 0) {
            url = Tools.getResource(classLoader, "icons/op_" + icon + ".gif");
            this.iconName = "op_" + icon;
        } else {
            String groupIconName = group;
            url = Tools.getResource(classLoader, "icons/group_" + groupIconName + ".gif");
            while (url == null && groupIconName.length() > 0) {
                if (groupIconName.indexOf(".") >= 0) {
                    groupIconName = groupIconName.substring(0, groupIconName.lastIndexOf("."));
                    url = Tools.getResource(classLoader, "icons/group_" + groupIconName + ".gif");
                    continue;
                }
                groupIconName = "";
            }
            this.iconName = "group_" + groupIconName;
        }
        if (url != null) {
            try {
                this.icon = ImageIO.read(url);
            }
            catch (IOException e) {
                this.iconName = null;
            }
        } else {
            this.iconName = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public Class getOperatorClass() {
        return this.clazz;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroup() {
        return this.group;
    }

    public Image getIcon() {
        return this.icon;
    }

    public String getIconName() {
        return this.iconName;
    }

    public String toString() {
        return "operator '" + this.name + "' loaded from " + this.clazz + ", description: " + this.description + ", group: " + this.group + ", icon: " + this.iconName;
    }

    public Operator createOperatorInstance() throws OperatorCreationException {
        Operator operator = null;
        try {
            Constructor constructor = this.clazz.getConstructor(class$edu$udo$cs$yale$operator$OperatorDescription == null ? (class$edu$udo$cs$yale$operator$OperatorDescription = OperatorDescription.class$("edu.udo.cs.yale.operator.OperatorDescription")) : class$edu$udo$cs$yale$operator$OperatorDescription);
            operator = (Operator)constructor.newInstance(this);
        }
        catch (InstantiationException e) {
            throw new OperatorCreationException(0, this.name + "(" + this.clazz.getName() + ")", e);
        }
        catch (IllegalAccessException e) {
            throw new OperatorCreationException(1, this.name + "(" + this.clazz.getName() + ")", e);
        }
        catch (NoSuchMethodException e) {
            throw new OperatorCreationException(2, this.name + "(" + this.clazz.getName() + ")", e);
        }
        catch (InvocationTargetException e) {
            throw new OperatorCreationException(3, this.name + "(" + this.clazz.getName() + ")", e);
        }
        return operator;
    }

    public int compareTo(Object o) {
        OperatorDescription d = (OperatorDescription)o;
        return this.name.compareTo(d.name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

