/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.OperatorService;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class IOConsumeOperator
extends Operator {
    private static final String[] DELETION_TYPES = new String[]{"delete_one", "delete_all"};
    private static final int DELETE_ONE = 0;
    private static final int DELETE_ALL = 1;
    private String[] objectArray = null;

    public IOConsumeOperator(OperatorDescription description) {
        super(description);
    }

    private Class getSelectedClass() {
        int ioType = this.getParameterAsInt("io_object");
        if (this.objectArray != null) {
            return OperatorService.getIOObjectClass(this.objectArray[ioType]);
        }
        return null;
    }

    public IOObject[] apply() throws OperatorException {
        Class clazz = this.getSelectedClass();
        if (clazz != null) {
            switch (this.getParameterAsInt("deletion_type")) {
                case 0: {
                    int number = this.getParameterAsInt("delete_which");
                    this.getInput(clazz, number - 1);
                    LogService.logMessage("Deleted " + number + ". " + clazz.getName() + ".", 2);
                    break;
                }
                case 1: {
                    int counter = 0;
                    try {
                        while (true) {
                            this.getInput(clazz);
                            ++counter;
                        }
                    }
                    catch (MissingIOObjectException e) {
                        LogService.logMessage("Deleted " + counter + " " + clazz.getName() + ".", 2);
                    }
                }
            }
        }
        return new IOObject[0];
    }

    public Class[] getInputClasses() {
        Class clazz = null;
        try {
            clazz = this.getSelectedClass();
        }
        catch (NullPointerException e) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (clazz != null) {
            return new Class[]{clazz};
        }
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[0];
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        Set ioObjects = OperatorService.getIOObjectsNames();
        this.objectArray = new String[ioObjects.size()];
        Iterator i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.objectArray[index++] = (String)i.next();
        }
        ParameterTypeSingle type = new ParameterTypeCategory("io_object", "The class of the object(s) which should be removed.", this.objectArray, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory("deletion_type", "Defines the type of deletion.", DELETION_TYPES, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("delete_which", "Defines which input object should be deleted (only used for deletion type 'delete_one').", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

