/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.NoOpUserError;
import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.GUIInputHandler;
import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.gui.TotDDialog;
import edu.udo.cs.yale.gui.WelcomeDialog;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.ParameterService;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class YaleGUI
extends Yale {
    public static final String UPDATE_CHECK_NAME = "yale.gui.update.check";
    private static final int NUMBER_OF_RECENT_FILES = 8;
    private static MainFrame mainFrame;
    private static LinkedList recentFiles;
    static /* synthetic */ Class class$edu$udo$cs$yale$gui$YaleGUI;

    protected static void setupPlaf() throws NoOpUserError {
        String plafName = System.getProperty("yale.gui.plaf");
        if (plafName != null && plafName.trim().length() > 0) {
            try {
                if (plafName.equals("system")) {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                } else if (plafName.equals("cross_platform")) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                } else {
                    UIManager.setLookAndFeel(plafName);
                }
                if (mainFrame != null) {
                    SwingUtilities.updateComponentTreeUI(mainFrame);
                    mainFrame.pack();
                }
            }
            catch (Exception e) {
                throw new NoOpUserError((Throwable)e, 915, new Object[]{plafName, e});
            }
        }
    }

    public void run(File file) throws Exception {
        YaleGUI.showLogo();
        YaleGUI.splashMessage("Initialising operators");
        YaleGUI.init();
        YaleGUI.setupPlaf();
        YaleGUI.splashMessage("Loading history");
        YaleGUI.loadRecentFileList();
        YaleGUI.splashMessage("Creating frame");
        mainFrame = new MainFrame();
        LogService.setOutputStream(YaleGUI.mainFrame.getMessageViewer().outputStream);
        YaleGUI.splashMessage("Ready.");
        YaleGUI.loadGUIProperties(mainFrame);
        mainFrame.setVisible(true);
        YaleGUI.hideLogo();
        String tipProperty = System.getProperty("yale.gui.tip.show");
        if (tipProperty.equals("true")) {
            new TotDDialog().setVisible(true);
        }
        if (file != null) {
            mainFrame.open(file);
        } else {
            new WelcomeDialog(mainFrame).setVisible(true);
        }
        String updateProperty = System.getProperty(UPDATE_CHECK_NAME);
        if (updateProperty.equals("true")) {
            boolean check = true;
            Calendar lastCheck = YaleGUI.loadLastUpdateCheckDate();
            if (lastCheck != null) {
                Calendar currentDate = Calendar.getInstance();
                currentDate.add(2, -1);
                if (!lastCheck.before(currentDate)) {
                    check = false;
                }
            }
            if (check) {
                mainFrame.checkForUpdates(false);
            }
        }
    }

    public static MainFrame getMainFrame() {
        return mainFrame;
    }

    public static void main(String[] args) throws Exception {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        File file = null;
        if (args.length > 0) {
            if (args.length != 1) {
                System.out.println("java " + (class$edu$udo$cs$yale$gui$YaleGUI == null ? (class$edu$udo$cs$yale$gui$YaleGUI = YaleGUI.class$("edu.udo.cs.yale.gui.YaleGUI")) : class$edu$udo$cs$yale$gui$YaleGUI).getName() + " [experimentfile]");
                return;
            }
            file = new File(args[0]);
            if (!file.exists()) {
                System.err.println("File '" + args[0] + "' not found.");
                return;
            }
            if (!file.canRead()) {
                System.err.println("Cannot read file '" + args[0] + "'.");
                return;
            }
        }
        YaleGUI.setInputHandler(new GUIInputHandler());
        new YaleGUI().run(file);
    }

    public static void useExperimentFile() {
        File file = YaleGUI.getExperiment().getExperimentFile();
        if (recentFiles.contains(file = new File(file.getAbsolutePath()))) {
            recentFiles.remove(file);
        }
        recentFiles.addFirst(file);
        while (recentFiles.size() > 8) {
            recentFiles.removeLast();
        }
    }

    public static List getRecentFiles() {
        return recentFiles;
    }

    private static void loadRecentFileList() {
        try {
            File file = ParameterService.getUserConfigFile("history");
            if (!file.exists()) {
                return;
            }
            BufferedReader in = new BufferedReader(new FileReader(file));
            recentFiles.clear();
            String line = null;
            while ((line = in.readLine()) != null) {
                recentFiles.add(new File(line));
            }
            in.close();
        }
        catch (IOException e) {
            SwingTools.showErrorMessage("Cannot read history file", e);
        }
    }

    private static void saveRecentFileList() {
        try {
            File file = ParameterService.getUserConfigFile("history");
            PrintWriter out = new PrintWriter(new FileWriter(file));
            Iterator i = recentFiles.iterator();
            while (i.hasNext()) {
                out.println(((File)i.next()).getAbsolutePath());
            }
            out.close();
        }
        catch (IOException e) {
            SwingTools.showErrorMessage("Cannot write history file", e);
        }
    }

    public static void saveLastUpdateCheckDate() {
        File file = ParameterService.getUserConfigFile("updatecheck.date");
        try {
            PrintWriter out = new PrintWriter(new FileWriter(file));
            Calendar currentDate = Calendar.getInstance();
            out.println(currentDate.get(1));
            out.println(currentDate.get(2));
            out.println(currentDate.get(5));
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Calendar loadLastUpdateCheckDate() {
        File file = ParameterService.getUserConfigFile("updatecheck.date");
        if (!file.exists()) {
            return null;
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String yearLine = in.readLine();
            String monthLine = in.readLine();
            String dayLine = in.readLine();
            in.close();
            int year = Integer.parseInt(yearLine.trim());
            int month = Integer.parseInt(monthLine.trim());
            int day = Integer.parseInt(dayLine.trim());
            Calendar lastCheck = Calendar.getInstance();
            lastCheck.set(1, year);
            lastCheck.set(2, month);
            lastCheck.set(5, day);
            return lastCheck;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void saveGUIProperties() {
        Properties properties = new Properties();
        MainFrame mainFrame = YaleGUI.getMainFrame();
        if (mainFrame != null) {
            properties.setProperty("yale.gui.geometry.x", "" + (int)mainFrame.getLocation().getX());
            properties.setProperty("yale.gui.geometry.y", "" + (int)mainFrame.getLocation().getY());
            properties.setProperty("yale.gui.geometry.width", "" + mainFrame.getWidth());
            properties.setProperty("yale.gui.geometry.height", "" + mainFrame.getHeight());
            properties.setProperty("yale.gui.geometry.divider.h", "" + mainFrame.getHorizontalDividerLocation());
            properties.setProperty("yale.gui.geometry.divider.v", "" + mainFrame.getVerticalDividerLocation());
            properties.setProperty("yale.gui.expertmode", "" + mainFrame.getPropertyTable().isExpertMode());
            File file = ParameterService.getUserConfigFile("gui.properties");
            try {
                FileOutputStream out = new FileOutputStream(file);
                properties.store(out, "Yale GUI properties");
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadGUIProperties(MainFrame mainFrame) {
        Properties properties = new Properties();
        File file = ParameterService.getUserConfigFile("gui.properties");
        if (file.exists()) {
            try {
                FileInputStream in = new FileInputStream(file);
                properties.load(in);
                ((InputStream)in).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                mainFrame.setLocation(Integer.parseInt(properties.getProperty("yale.gui.geometry.x")), Integer.parseInt(properties.getProperty("yale.gui.geometry.y")));
                mainFrame.setSize(new Dimension(Integer.parseInt(properties.getProperty("yale.gui.geometry.width")), Integer.parseInt(properties.getProperty("yale.gui.geometry.height"))));
                mainFrame.setDividerLocations(Integer.parseInt(properties.getProperty("yale.gui.geometry.divider.h")), Integer.parseInt(properties.getProperty("yale.gui.geometry.divider.v")));
                mainFrame.getPropertyTable().setExpertMode(Boolean.valueOf(properties.getProperty("yale.gui.expertmode")));
                mainFrame.updateToggleExpertModeIcon();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Yale.registerYaleProperty(new ParameterTypeBoolean(UPDATE_CHECK_NAME, "Check for new Yale versions at start up time?", true));
        recentFiles = new LinkedList();
    }

    private static class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        public void run() {
            LogService.logMessage("Running shutdown sequence.", 3);
            YaleGUI.saveRecentFileList();
            YaleGUI.saveGUIProperties();
        }
    }
}

