/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.ExperimentEditor;
import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.OperatorPropertyTable;
import edu.udo.cs.yale.gui.OperatorTree;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class TreePanel
extends JSplitPane
implements ExperimentEditor {
    private OperatorTree operatorTree;
    private OperatorPropertyTable propertyTable;

    public TreePanel(MainFrame mainFrame) {
        super(1);
        this.operatorTree = new OperatorTree(mainFrame);
        this.propertyTable = new OperatorPropertyTable(mainFrame);
        JPanel moveOperatorPanel = new JPanel(new BorderLayout());
        JScrollPane treeScrollPane = new JScrollPane(this.operatorTree);
        moveOperatorPanel.add((Component)treeScrollPane, "Center");
        Dimension treeMin = this.operatorTree.getMinimumSize();
        treeScrollPane.setPreferredSize(new Dimension((int)treeMin.getWidth(), (int)treeMin.getHeight()));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 4));
        JButton downButton = new JButton(new ImageIcon(Tools.getResource("icons/icon_down.gif")));
        downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreePanel.this.operatorTree.moveDown();
            }
        });
        buttonPanel.add(downButton);
        JButton upButton = new JButton(new ImageIcon(Tools.getResource("icons/icon_up.gif")));
        upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreePanel.this.operatorTree.moveUp();
            }
        });
        buttonPanel.add(upButton);
        JButton newButton = new JButton(this.operatorTree.NEW_OPERATOR_ACTION);
        newButton.setText("");
        buttonPanel.add(newButton);
        JButton deleteButton = new JButton(this.operatorTree.DELETE_OPERATOR_ACTION);
        deleteButton.setText("");
        buttonPanel.add(deleteButton);
        moveOperatorPanel.add((Component)buttonPanel, "South");
        this.add(moveOperatorPanel);
        this.add(new JScrollPane(this.propertyTable));
    }

    public void experimentChanged(Operator operator) {
        this.operatorTree.setOperator(operator);
        this.propertyTable.setOperator(null);
    }

    public Component getMainComponent() {
        return this.operatorTree;
    }

    public OperatorTree getOperatorTree() {
        return this.operatorTree;
    }

    public OperatorPropertyTable getPropertyTable() {
        return this.propertyTable;
    }

    public void validateExperiment() {
    }
}

