/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.BreakpointListener;
import edu.udo.cs.yale.ExperimentListener;
import edu.udo.cs.yale.operator.ExperimentOperator;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.Operator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class StatusBar
extends Box
implements BreakpointListener,
ExperimentListener {
    private JLabel clock = StatusBar.createLabel(StatusBar.getTime(), true);
    private JLabel operator = StatusBar.createLabel("                         ", false);
    private Operator currentOperator = null;
    private int breakpoint = -1;

    public StatusBar() {
        super(0);
        this.operator.setPreferredSize(new Dimension(500, 8));
        this.add(this.operator);
        this.add(StatusBar.createHorizontalGlue());
        this.add(this.clock);
        new Thread(){

            public void run() {
                this.setPriority(1);
                try {
                    while (true) {
                        long execTime;
                        StatusBar.this.clock.setText(StatusBar.getTime());
                        if (StatusBar.this.currentOperator != null && (execTime = System.currentTimeMillis() - StatusBar.this.currentOperator.getStartTime()) > 1000L && StatusBar.this.breakpoint < 0) {
                            StatusBar.this.operator.setText("[" + StatusBar.this.currentOperator.getApplyCount() + "] " + StatusBar.this.currentOperator.getName() + "  " + execTime / 1000L + " s");
                        }
                        1.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }.start();
    }

    private static Border createBorder() {
        return new Border(){

            public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                Color highlight = c.getBackground().brighter().brighter();
                Color shadow = c.getBackground().darker().darker();
                Color oldColor = g.getColor();
                g.translate(x, y);
                g.setColor(shadow);
                g.drawLine(3, 0, 3, h - 2);
                g.drawLine(3, 0, w - 3, 0);
                g.setColor(highlight);
                g.drawLine(3, h - 2, w - 3, h - 2);
                g.drawLine(w - 3, 1, w - 3, h - 2);
                g.translate(-x, -y);
                g.setColor(oldColor);
            }

            public Insets getBorderInsets(Component c) {
                return new Insets(1, 4, 2, 3);
            }

            public boolean isBorderOpaque() {
                return false;
            }
        };
    }

    private static JLabel createLabel(String text, boolean border) {
        JLabel label = new JLabel(text);
        if (border) {
            label.setBorder(StatusBar.createBorder());
        }
        label.setFont(label.getFont().deriveFont(0));
        return label;
    }

    private static String getTime() {
        return DateFormat.getTimeInstance().format(new Date());
    }

    public void breakpointReached(Operator op, IOContainer io, int location) {
        this.breakpoint = location;
        this.operator.setText("[" + op.getApplyCount() + "] " + op.getName() + ": breakpoint reached " + (this.breakpoint == 0 ? "before" : "after") + " operator, press resume...");
    }

    public void resume() {
        this.breakpoint = -1;
        if (this.currentOperator != null) {
            this.setText();
        } else {
            this.operator.setText(" ");
        }
    }

    public void experimentStep(ExperimentOperator op) {
        this.currentOperator = op.getExperiment().getCurrentOperator();
        this.setText();
    }

    public void experimentEnded() {
        this.operator.setText(" ");
        this.currentOperator = null;
    }

    private void setText() {
        this.operator.setText("[" + this.currentOperator.getApplyCount() + "] " + this.currentOperator.getName());
    }
}

