/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.InfoBox;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JWindow;

public class SplashScreen
extends InfoBox
implements MouseListener {
    private Image logo;
    private static Image javaLogo;
    private static final Paint MAIN_PAINT;
    private double logoHeight = 1.0;
    private double dropSpeed;
    private JWindow window = new JWindow();
    private String message = "Starting up.";

    public SplashScreen(String productName, String version, Image logo) {
        super(400, 300, logo == null ? 50 : (int)((double)logo.getHeight(null) * 1.2), productName, 48, version, 36);
        this.logo = logo;
        if (logo != null) {
            this.addMouseListener(this);
        }
        this.window.getContentPane().add(this);
        this.window.pack();
        this.window.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2.0 - (double)(this.window.getWidth() / 2)), (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2.0 - (double)(this.window.getHeight() / 2)));
    }

    public void showSplashScreen() {
        this.window.setVisible(true);
    }

    public void dispose() {
        this.window.dispose();
    }

    protected void drawNorth(Graphics2D g) {
        super.drawNorth(g);
        if (this.logo != null) {
            Graphics2D scaled = (Graphics2D)g.create(this.getWidth() - this.logo.getWidth(null) - 15, (int)((double)this.logo.getHeight(null) * 0.1) + (int)((1.0 - this.logoHeight) * (double)this.logo.getHeight(null)), this.logo.getWidth(null), this.logo.getHeight(null));
            scaled.scale(1.0, this.logoHeight);
            scaled.drawImage(this.logo, 0, 0, null);
            scaled.dispose();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public void drawMain(Graphics2D g) {
        g.setPaint(MAIN_PAINT);
        g.fillRect(0, 0, this.getWidth(), this.getMainHeight());
        g.setPaint(NORTH_PAINT);
        g.setFont(new Font("LucidaSans", 1, 12));
        g.drawString("YALE - Yet Another Learning Environment", 10, 20);
        g.setFont(new Font("LucidaSans", 1, 10));
        g.drawString(this.message, 10, 35);
        g.setFont(new Font("LucidaSans", 0, 10));
        g.drawString("Copyright (C) 2001-2005 by", 10, 100);
        g.drawString("Simon Fischer, Ralf Klinkenberg,", 10, 113);
        g.drawString("Ingo Mierswa, Katharina Morik, and Oliver Ritthoff", 10, 126);
        g.drawString("Use is subject to the GNU General Public License", 10, 139);
        if (javaLogo != null) {
            g.drawImage(javaLogo, 335, 85, null);
        }
    }

    public void mouseClicked(MouseEvent e) {
        int lx = this.getWidth() - this.logo.getWidth(null) - 15;
        int ly = (int)((double)this.logo.getHeight(null) * 0.1);
        if (e.getX() >= lx && e.getX() >= ly && e.getX() < lx + this.logo.getWidth(null) && e.getY() < ly + this.logo.getHeight(null)) {
            new Thread(){

                public void run() {
                    this.setPriority(1);
                    SplashScreen.this.dropSpeed = 0.01;
                    while (SplashScreen.this.logoHeight > 0.0) {
                        SplashScreen.this.logoHeight -= SplashScreen.this.dropSpeed;
                        SplashScreen.this.dropSpeed += 0.01;
                        SplashScreen.this.repaint();
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }.start();
        }
    }

    public void mousePressed(MouseEvent param1) {
    }

    public void mouseReleased(MouseEvent param1) {
    }

    public void mouseEntered(MouseEvent param1) {
    }

    public void mouseExited(MouseEvent param1) {
    }

    public void setMessage(String message) {
        this.message = message;
        this.repaint();
    }

    static {
        MAIN_PAINT = Color.lightGray;
        try {
            javaLogo = ImageIO.read(Tools.getResource("java_cup_logo.gif"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

