/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.ErrorDialog;
import edu.udo.cs.yale.gui.PropertyTable;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;

public class SettingsPropertyTable
extends PropertyTable {
    private ParameterType[] parameterTypes;

    public SettingsPropertyTable() {
        this(Yale.getYaleProperties());
    }

    public SettingsPropertyTable(Collection allProperties) {
        super(new String[]{"Property", "Value"});
        this.parameterTypes = new ParameterType[allProperties.size()];
        allProperties.toArray(this.parameterTypes);
        this.updateTableData(this.parameterTypes.length);
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            ParameterType type = this.parameterTypes[i];
            String key = this.parameterTypes[i].getKey();
            this.getDefaultModel().setValueAt(key, i, 0);
            Object property = System.getProperty(key);
            if (property == null) {
                property = type.getDefaultValue();
            }
            this.getDefaultModel().setValueAt(property, i, 1);
        }
        this.updateEditorsAndRenderers();
    }

    public ParameterType getParameterType(int row) {
        return this.parameterTypes[row];
    }

    public Operator getOperator(int row) {
        return null;
    }

    private String getPropertyValue(int index) {
        Object value = this.getDefaultModel().getValueAt(index, 1);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public void applyProperties() {
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            String value = this.getPropertyValue(i);
            if (value == null) continue;
            if (this.parameterTypes[i].getKey().equals("yale.gui.plaf")) {
                String oldValue = System.getProperty(this.parameterTypes[i].getKey());
                if (oldValue.equals(value)) continue;
                try {
                    System.setProperty(this.parameterTypes[i].getKey(), value);
                    YaleGUI.setupPlaf();
                }
                catch (Exception e) {
                    System.setProperty(this.parameterTypes[i].getKey(), oldValue);
                    ErrorDialog.create("While setting plaf", e).setVisible(true);
                }
                continue;
            }
            System.setProperty(this.parameterTypes[i].getKey(), value);
        }
    }

    public void writeProperties(PrintWriter out) throws IOException {
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            String key = this.parameterTypes[i].getKey();
            String value = this.getPropertyValue(i);
            if (value == null) continue;
            System.setProperty(key, value);
            out.println("# " + this.parameterTypes[i].getDescription());
            out.println(key + " = " + value);
        }
    }
}

