/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.gui.PropertyCellEditor;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeValue;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class ParameterValueCellEditor
extends AbstractCellEditor
implements PropertyCellEditor {
    private JPanel panel = new JPanel();
    private JComboBox operatorCombo = new JComboBox();
    private JComboBox parameterCombo = new JComboBox();
    private JTextField parameterField = new JTextField("unknown");
    private OperatorChain parentOperator;
    private Experiment experiment;
    private ParameterTypeValue type;

    public ParameterValueCellEditor(ParameterTypeValue type, Experiment experiment, OperatorChain parentOperator) {
        this.type = type;
        this.parentOperator = parentOperator;
        this.experiment = experiment;
        this.operatorCombo = this.createOperatorCombo();
        this.parameterCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ParameterValueCellEditor.this.parameterField.setText("unknown");
                ParameterValueCellEditor.this.fireEditingStopped();
            }
        });
        this.fillParameterCombo();
        this.panel.setLayout(new GridLayout(1, 3));
        this.panel.add(this.operatorCombo);
        this.panel.add(this.parameterCombo);
        this.panel.add(this.parameterField);
    }

    private JComboBox createOperatorCombo() {
        List allInnerOps = this.parentOperator.getAllInnerOperators();
        Vector<String> allOpNames = new Vector<String>();
        Iterator i = allInnerOps.iterator();
        while (i.hasNext()) {
            allOpNames.add(((Operator)i.next()).getName());
        }
        Collections.sort(allOpNames);
        JComboBox<String> combo = new JComboBox<String>(allOpNames);
        combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ParameterValueCellEditor.this.fillParameterCombo();
                ParameterValueCellEditor.this.fireEditingStopped();
            }
        });
        if (combo.getItemCount() == 0) {
            combo.addItem("add inner operators");
        }
        return combo;
    }

    private void fillParameterCombo() {
        this.parameterCombo.removeAllItems();
        Operator operator = this.experiment.getOperator((String)this.operatorCombo.getSelectedItem());
        if (operator != null) {
            Iterator i = operator.getParameterTypes().iterator();
            while (i.hasNext()) {
                this.parameterCombo.addItem(((ParameterType)i.next()).getKey());
            }
        }
        if (this.parameterCombo.getItemCount() == 0) {
            this.parameterCombo.addItem("no params");
        }
        this.parameterCombo.setSelectedIndex(0);
    }

    public Object getCellEditorValue() {
        String result = "operator#" + this.operatorCombo.getSelectedItem() + "#" + this.parameterCombo.getSelectedItem() + "#" + this.parameterField.getText();
        return result;
    }

    public void setValue(String valueName) {
        if (valueName != null) {
            String[] components = valueName.split("#");
            if (components.length == 3) {
                String operator = components[1];
                String parameterName = components[2];
                this.operatorCombo.setSelectedItem(operator);
                this.parameterCombo.setSelectedItem(parameterName);
                Operator op = this.experiment.getOperator(operator);
                ParameterType type = op.getParameters().getParameterType(parameterName);
                Object defaultValue = type.getDefaultValue();
                if (defaultValue != null) {
                    this.parameterField.setText(defaultValue.toString());
                } else {
                    this.parameterField.setText("unknown");
                }
            } else if (components.length == 4) {
                String operator = components[1];
                String parameterName = components[2];
                String parameterValue = components[3];
                this.operatorCombo.setSelectedItem(operator);
                this.parameterCombo.setSelectedItem(parameterName);
                if (parameterValue.equals("unknown")) {
                    Operator op = this.experiment.getOperator(operator);
                    ParameterType type = op.getParameters().getParameterType(parameterName);
                    Object defaultValue = type.getDefaultValue();
                    if (defaultValue != null) {
                        this.parameterField.setText(defaultValue.toString());
                    } else {
                        this.parameterField.setText("unknown");
                    }
                } else {
                    this.parameterField.setText(parameterValue);
                }
            } else {
                this.operatorCombo.setSelectedIndex(0);
                this.parameterCombo.setSelectedIndex(0);
                this.parameterField.setText("unknown");
            }
        } else {
            this.operatorCombo.setSelectedIndex(0);
            this.parameterCombo.setSelectedIndex(0);
            this.parameterField.setText("unknown");
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.setValue((String)value);
        return this.panel;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return true;
    }
}

