/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.OperatorInfoPanel;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.tools.GroupTree;
import edu.udo.cs.yale.tools.OperatorService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NewOperatorDialog
extends JDialog {
    private OperatorDescription description = null;
    private boolean ok = false;
    private JPanel mainPanel = new JPanel();
    private OperatorInfoPanel operatorInfo = null;
    private JList operatorList = new JList();
    private Class inputClass = null;
    private Class outputClass = null;
    private String group = null;
    private boolean onlyChains = false;

    public NewOperatorDialog() {
        super(YaleGUI.getMainFrame(), "New Operator", true);
        this.mainPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewOperatorDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewOperatorDialog.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        this.mainPanel.add((Component)buttonPanel, "South");
        JPanel searchPanel = new JPanel(new GridLayout(3, 2));
        searchPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10), BorderFactory.createTitledBorder("Search Constraints")));
        this.mainPanel.add((Component)searchPanel, "North");
        final String[] ioObjects = this.convertSet2Strings(OperatorService.getIOObjectsNames());
        String[] inputObjects = new String[ioObjects.length + 1];
        inputObjects[0] = "Any";
        System.arraycopy(ioObjects, 0, inputObjects, 1, ioObjects.length);
        LinkedList<String> allGroups = new LinkedList<String>();
        allGroups.add("Any");
        GroupTree groupTree = OperatorService.getGroups();
        this.addGroups(groupTree, null, allGroups);
        Collections.sort(allGroups);
        final String[] groupArray = new String[allGroups.size()];
        allGroups.toArray(groupArray);
        final JComboBox<String> groupComboBox = new JComboBox<String>(groupArray);
        groupComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex = groupComboBox.getSelectedIndex();
                if (selectedIndex <= 0) {
                    NewOperatorDialog.this.group = null;
                } else {
                    NewOperatorDialog.this.group = groupArray[selectedIndex];
                }
                NewOperatorDialog.this.updateOperatorList();
            }
        });
        searchPanel.add(new JLabel("Operator group: "));
        searchPanel.add(groupComboBox);
        final JComboBox<String> inputType = new JComboBox<String>(inputObjects);
        inputType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex = inputType.getSelectedIndex();
                if (selectedIndex <= 0) {
                    NewOperatorDialog.this.inputClass = null;
                } else {
                    NewOperatorDialog.this.inputClass = OperatorService.getIOObjectClass(ioObjects[selectedIndex - 1]);
                }
                NewOperatorDialog.this.updateOperatorList();
            }
        });
        searchPanel.add(new JLabel("Required Input: "));
        searchPanel.add(inputType);
        final JComboBox<String> outputType = new JComboBox<String>(inputObjects);
        outputType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex = outputType.getSelectedIndex();
                if (selectedIndex <= 0) {
                    NewOperatorDialog.this.outputClass = null;
                } else {
                    NewOperatorDialog.this.outputClass = OperatorService.getIOObjectClass(ioObjects[selectedIndex - 1]);
                }
                NewOperatorDialog.this.updateOperatorList();
            }
        });
        searchPanel.add(new JLabel("Delivered Output: "));
        searchPanel.add(outputType);
        this.operatorList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                String selection = (String)NewOperatorDialog.this.operatorList.getSelectedValue();
                NewOperatorDialog.this.setSelectedOperator(selection);
            }
        });
        this.operatorList.setSelectionMode(0);
        JScrollPane listScrollPane = new JScrollPane(this.operatorList);
        GridBagLayout layout = new GridBagLayout();
        JPanel listPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        listPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 10, 10, 5), BorderFactory.createTitledBorder("Matching Operators")));
        layout.setConstraints(listScrollPane, c);
        listPanel.add(listScrollPane);
        this.mainPanel.add((Component)listPanel, "West");
        this.updateOperatorList();
        this.setSize(600, 500);
        this.setLocationRelativeTo(YaleGUI.getMainFrame());
    }

    private void updateOperatorList() {
        this.operatorList.removeAll();
        Vector<String> operators = new Vector<String>();
        Iterator i = OperatorService.getOperatorNames().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            OperatorDescription description = OperatorService.getOperatorDescription(name);
            if (this.group != null && description.getGroup().indexOf(this.group) < 0) continue;
            try {
                Operator operator = description.createOperatorInstance();
                if (this.inputClass != null && !this.containsClass(operator.getInputClasses(), this.inputClass) || this.outputClass != null && !this.containsClass(operator.getOutputClasses(), this.outputClass)) {
                    continue;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            operators.add(name);
        }
        Collections.sort(operators);
        this.operatorList.setListData(operators);
        if (operators.size() > 0) {
            this.operatorList.setSelectedIndex(0);
        }
    }

    private boolean containsClass(Class[] classes, Class clazz) {
        for (int i = 0; i < classes.length; ++i) {
            if (!clazz.isAssignableFrom(classes[i])) continue;
            return true;
        }
        return false;
    }

    private void addGroups(GroupTree tree, String parentName, Collection names) {
        Iterator i = tree.getSubGroups().iterator();
        while (i.hasNext()) {
            GroupTree subGroup = (GroupTree)i.next();
            String name = parentName == null ? subGroup.getName() : parentName + "." + subGroup.getName();
            names.add(name);
            this.addGroups(subGroup, name, names);
        }
    }

    private void setSelectedOperator(String descriptionName) {
        if (this.operatorInfo != null) {
            this.mainPanel.remove(this.operatorInfo);
        }
        if (descriptionName != null) {
            this.description = OperatorService.getOperatorDescription(descriptionName);
            this.operatorInfo = new OperatorInfoPanel(this.description);
        } else {
            this.operatorInfo = new OperatorInfoPanel(null);
        }
        this.operatorInfo.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 10, 10), BorderFactory.createTitledBorder("Operator Info")));
        this.mainPanel.add((Component)this.operatorInfo, "Center");
        this.operatorInfo.revalidate();
    }

    private String[] convertSet2Strings(Collection ioObjects) {
        String[] objectArray = new String[ioObjects.size()];
        Iterator i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            objectArray[index++] = (String)i.next();
        }
        return objectArray;
    }

    private String[] convertDescriptions2Strings(Set ioObjects) {
        String[] objectArray = new String[ioObjects.size()];
        Iterator i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            objectArray[index++] = ((OperatorDescription)i.next()).getName();
        }
        return objectArray;
    }

    public Operator getOperator() throws OperatorCreationException {
        if (this.description != null) {
            Operator operator = OperatorService.createOperator(this.description);
            operator.register(Yale.getExperiment(), this.description.getName());
            return operator;
        }
        return null;
    }

    private void ok() {
        this.ok = true;
        this.dispose();
    }

    private void cancel() {
        this.ok = false;
        this.dispose();
    }

    public boolean isOk() {
        return this.ok;
    }
}

