/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MetaDataViewer
extends JPanel {
    private ExampleSet exampleSet;
    private int firstAttribute;
    private int lastAttribute;
    private JLabel dataLabel = new JLabel();

    public MetaDataViewer(ExampleSet exampleSet, int maxNumberOfAttributes) {
        super(new BorderLayout());
        this.exampleSet = exampleSet;
        this.exampleSet.recalculateAllAttributeStatistics();
        this.firstAttribute = 1;
        this.lastAttribute = Math.min(maxNumberOfAttributes, exampleSet.getNumberOfAttributes());
        JPanel dataControl = new JPanel(new FlowLayout(0));
        dataControl.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        JLabel label = new JLabel("Attribute range from: ");
        dataControl.add(label);
        final JTextField fromAttributeField = new JTextField(10);
        fromAttributeField.setText(this.firstAttribute + "");
        dataControl.add(fromAttributeField);
        label = new JLabel(" to: ");
        dataControl.add(label);
        final JTextField toAttributeField = new JTextField(10);
        toAttributeField.setText(this.lastAttribute + "");
        dataControl.add(toAttributeField);
        JButton updateButton = new JButton("Update");
        updateButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                try {
                    int newFirstAttribute = Integer.parseInt(fromAttributeField.getText());
                    if (newFirstAttribute >= 1 && newFirstAttribute < MetaDataViewer.this.exampleSet.getNumberOfAttributes()) {
                        MetaDataViewer.this.firstAttribute = newFirstAttribute;
                    }
                }
                catch (NumberFormatException ex) {
                }
                finally {
                    fromAttributeField.setText(MetaDataViewer.this.firstAttribute + "");
                }
                try {
                    int newLastAttribute = Integer.parseInt(toAttributeField.getText());
                    if (newLastAttribute >= 1 && newLastAttribute <= MetaDataViewer.this.exampleSet.getNumberOfAttributes()) {
                        MetaDataViewer.this.lastAttribute = newLastAttribute;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                finally {
                    toAttributeField.setText(MetaDataViewer.this.lastAttribute + "");
                }
                if (MetaDataViewer.this.firstAttribute > MetaDataViewer.this.lastAttribute) {
                    MetaDataViewer.this.firstAttribute = MetaDataViewer.this.lastAttribute;
                    fromAttributeField.setText(MetaDataViewer.this.firstAttribute + "");
                }
                MetaDataViewer.this.update();
            }
        });
        dataControl.add(updateButton);
        this.add((Component)dataControl, "North");
        this.add((Component)this.dataLabel, "Center");
        this.update();
    }

    private void update() {
        this.remove(this.dataLabel);
        this.dataLabel = new JLabel("<html>" + this.dataToHTML() + "</html>");
        this.dataLabel.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        this.dataLabel.setFont(this.dataLabel.getFont().deriveFont(0));
        this.add((Component)this.dataLabel, "Center");
        this.validate();
    }

    private String dataToHTML() {
        StringBuffer buffer = new StringBuffer("");
        buffer.append("<h2>" + Tools.classNameWOPackage(this.exampleSet.getClass()) + "</h2>");
        buffer.append("<b>Number of examples:</b> " + this.exampleSet.getSize() + "<br>");
        buffer.append("<b>Number of attributes:</b> " + this.exampleSet.getNumberOfAttributes() + "<br>");
        buffer.append("<table bgcolor=\"#E3D8C3\" border=\"1\">");
        buffer.append("<tr bgcolor=\"#ccccff\"><th>Index</th><th>Name</th><th>Generated from</th><th>Unit</th><th>Type</th><th>Blocktype</th><th>Blocknr.</th><th>Values</th></tr>");
        buffer.append("<tr bgcolor=\"#C3B8A3\"><td colspan=\"8\" border=\"0\"><b>Regular attributes</b></td></tr>");
        if (this.firstAttribute > 1) {
            buffer.append("<tr><td colspan=\"8\">... " + (this.firstAttribute - 1) + " attributes ... </td></tr>");
        }
        for (int i = this.firstAttribute - 1; i < this.lastAttribute; ++i) {
            buffer.append(this.exampleSet.getAttribute(i).toHTML());
        }
        if (this.lastAttribute < this.exampleSet.getNumberOfAttributes()) {
            buffer.append("<tr><td colspan=\"8\">... " + (this.exampleSet.getNumberOfAttributes() - this.lastAttribute) + " attributes ... </td></tr>");
        }
        Iterator i = this.exampleSet.getSpecialAttributeNames().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            MetaDataViewer.specialAttributeToHTML(this.exampleSet.getAttribute(name), name, buffer);
        }
        buffer.append("</table>");
        return buffer.toString();
    }

    private static void specialAttributeToHTML(Attribute attribute, String name, StringBuffer buffer) {
        if (attribute != null) {
            buffer.append("<tr bgcolor=\"#C3B8A3\"><td colspan=\"8\" border=\"0\"><b>" + name + "</b></td></tr>");
            buffer.append(attribute.toHTML());
        }
    }
}

