/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.SearchDialog;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class MessageViewer
extends JScrollPane
implements MouseListener {
    public final MessageViewerOutputStream outputStream = new MessageViewerOutputStream();
    public final Action CLEAR_MESSAGE_VIEWER_ACTION = new ClearMessageAction();
    public final Action SAVE_LOGFILE_ACTION = new SaveLogFileAction();
    public final Action FIND_ACTION = new FindAction();
    private JTextPane textArea;
    private String searchPattern = null;

    private Color getHighlightingColor(String propertyName) {
        String propertyString = System.getProperty(propertyName);
        String[] colors = propertyString.split(",");
        Color color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
        return color;
    }

    public MessageViewer() {
        this(new JTextPane());
    }

    private MessageViewer(JTextPane textArea) {
        super(textArea);
        this.textArea = textArea;
        textArea.setEditable(false);
        textArea.addMouseListener(this);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getModifiers() == 4) {
            this.createPopupMenu().show(this.textArea, e.getX(), e.getY());
        }
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.CLEAR_MESSAGE_VIEWER_ACTION);
        menu.add(this.SAVE_LOGFILE_ACTION);
        menu.add(this.FIND_ACTION);
        return menu;
    }

    public String getLogMessage() {
        return this.textArea.getText();
    }

    public void clear() {
        this.outputStream.clear();
        this.textArea.setText("");
    }

    private class MessageViewerOutputStream
    extends OutputStream {
        private StringBuffer currentString;
        private LinkedList lineLengths = new LinkedList();

        private MessageViewerOutputStream() {
            this.currentString = new StringBuffer();
        }

        public void write(int b) {
            char c = (char)b;
            switch (b) {
                case 10: 
                case 13: {
                    int length = this.currentString.length();
                    if (length <= 0) break;
                    StyledDocument doc = MessageViewer.this.textArea.getStyledDocument();
                    try {
                        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                        if (this.currentString.toString().toLowerCase().indexOf("[warning]") != -1) {
                            StyleConstants.setForeground(attributeSet, MessageViewer.this.getHighlightingColor("yale.gui.messageviewer.highlight.warnings"));
                        }
                        if (this.currentString.toString().toLowerCase().indexOf("[error]") != -1 || this.currentString.toString().toLowerCase().indexOf("[exception]") != -1 || this.currentString.toString().toLowerCase().indexOf("[fatal]") != -1) {
                            StyleConstants.setForeground(attributeSet, MessageViewer.this.getHighlightingColor("yale.gui.messageviewer.highlight.errors"));
                        }
                        doc.insertString(doc.getLength(), this.currentString.toString() + "\n", attributeSet);
                        this.lineLengths.add(new Integer(length + 1));
                        String maxRowsString = System.getProperty("yale.gui.messageviewer.rowlimit");
                        int maxRows = Integer.parseInt(maxRowsString);
                        if (maxRows >= 0) {
                            while (this.lineLengths.size() > maxRows) {
                                int lineLength = (Integer)this.lineLengths.removeFirst();
                                doc.remove(0, lineLength);
                            }
                        }
                        MessageViewer.this.textArea.setCaretPosition(MessageViewer.this.textArea.getDocument().getLength());
                        this.currentString = new StringBuffer();
                    }
                    catch (BadLocationException e) {
                        SwingTools.showSimpleErrorMessage("Error during XML parsing: ", e);
                    }
                    break;
                }
                case 9: {
                    this.currentString.append("   ");
                    break;
                }
                default: {
                    this.currentString.append(c);
                }
            }
        }

        public void clear() {
            this.currentString = new StringBuffer();
            this.lineLengths.clear();
        }
    }

    private class FindAction
    extends AbstractAction {
        private FindAction() {
            super("Find...");
            this.putValue("ShortDescription", "Find text in the logging output.");
            this.putValue("MnemonicKey", new Integer(70));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 2));
        }

        public void actionPerformed(ActionEvent e) {
            new SearchDialog(MessageViewer.this, MessageViewer.this.textArea).setVisible(true);
        }
    }

    private class SaveLogFileAction
    extends AbstractAction {
        private SaveLogFileAction() {
            super("Save log file...");
            this.putValue("ShortDescription", "Save the logging output to a file");
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent e) {
            File file = new File("./");
            String logFile = Yale.getExperiment().getRootOperator().getParameterAsString("logfile");
            if (logFile != null) {
                file = Yale.getExperiment().resolveFileName(logFile);
            } else {
                file = Yale.getExperiment().getExperimentFile();
                if (file != null) {
                    file = file.getParentFile();
                }
            }
            file = SwingTools.chooseFile(MessageViewer.this, file, false);
            if (file != null) {
                try {
                    PrintWriter out = new PrintWriter(new FileWriter(file));
                    out.println(MessageViewer.this.textArea.getText());
                    out.close();
                }
                catch (IOException ex) {
                    SwingTools.showErrorMessage("Cannot write log file.", ex);
                }
            }
        }
    }

    private class ClearMessageAction
    extends AbstractAction {
        private ClearMessageAction() {
            super("Clear message viewer", new ImageIcon(Tools.getResource("icons/icon_clear_messages.gif")));
            this.putValue("ShortDescription", "Clear the message viewer");
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            MessageViewer.this.clear();
        }
    }
}

