/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.ListPropertyDialog;
import edu.udo.cs.yale.gui.PropertyCellEditor;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;

public class ListCellEditor
extends AbstractCellEditor
implements PropertyCellEditor {
    private JButton button = new JButton("Edit list");
    private ParameterTypeList type;
    private List parameterList = new LinkedList();
    private Operator operator;

    public ListCellEditor(final ParameterTypeList type, final Operator operator) {
        this.type = type;
        this.operator = operator;
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setToolTipText(type.getDescription());
        this.setButtonText();
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ListPropertyDialog dialog = new ListPropertyDialog(type, ListCellEditor.this.parameterList, operator);
                dialog.setVisible(true);
                if (dialog.isOk()) {
                    ListCellEditor.this.fireEditingStopped();
                    ListCellEditor.this.setButtonText();
                } else {
                    ListCellEditor.this.fireEditingCanceled();
                }
            }
        });
    }

    public Object getCellEditorValue() {
        return this.parameterList;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.parameterList = (List)value;
        this.setButtonText();
        return this.button;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return true;
    }

    private void setButtonText() {
        this.button.setText("Edit List (" + this.parameterList.size() + ")");
    }
}

