/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.gui.GNUPlotDialog;
import edu.udo.cs.yale.gui.Plotter;
import edu.udo.cs.yale.gui.SimpleFileFilter;
import edu.udo.cs.yale.gui.SwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class GnuPlotPlotter
extends JPanel
implements Plotter {
    private static final int X_AXIS = 0;
    private static final int Y_AXIS = 1;
    private Statistics statistics;
    private int[] axis = new int[]{-1, -1};
    private boolean[] columns;
    private int rotX = 60;
    private int rotZ = 30;
    private Image cachedImage = null;
    private GNUPlotDialog gnuPlotDialog = new GNUPlotDialog(this);

    public GnuPlotPlotter() {
        this.setBackground(Color.white);
        RotationListener listener = new RotationListener();
        this.addMouseMotionListener(listener);
        this.addMouseListener(listener);
    }

    public GnuPlotPlotter(Statistics statistics) {
        this();
        this.setStatistics(statistics);
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
        statistics.addStatisticsListener(this);
        this.columns = new boolean[statistics.getNumberOfColumns()];
    }

    public Component getPlotter() {
        return this;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public String getAxisName(int index) {
        switch (index) {
            case 0: {
                return "x-Axis";
            }
            case 1: {
                return "y-Axis";
            }
        }
        return "none";
    }

    public int getValuePlotSelectionType() {
        return 1;
    }

    public Icon getIcon(int index) {
        return null;
    }

    public void statisticsUpdated(Statistics source) {
        this.repaint();
    }

    public boolean isSaveable() {
        return true;
    }

    public void save() {
        JFileChooser chooser = SwingTools.createFileChooser(null, false, new FileFilter[]{new SimpleFileFilter("Raw statistics", ".dat", 1), new SimpleFileFilter("GNUPlot file", ".gnu", 2)});
        if (chooser.showSaveDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            try {
                int id = ((SimpleFileFilter)chooser.getFileFilter()).getId();
                switch (id) {
                    case 1: {
                        PrintWriter out1 = new PrintWriter(new FileWriter(file));
                        this.statistics.write(out1);
                        out1.close();
                        break;
                    }
                    case 2: {
                        if (this.axis[0] < 0) {
                            throw new Exception("No x-Axis selected!");
                        }
                        PrintStream out2 = new PrintStream(new FileOutputStream(file));
                        this.statistics.writeGNUPlot(out2, this.axis[0], this.axis[1], this.getZ(), this.gnuPlotDialog.getLineType(), this.gnuPlotDialog.getGNUPlotCommands() + "\n" + "set view " + this.rotX + "," + this.rotZ + "", null);
                        out2.close();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown FileFilter id: " + id + " (this cannot happen)!");
                    }
                }
            }
            catch (Exception ex) {
                SwingTools.showErrorMessage("Cannot write to file '" + file + "'", ex);
            }
        }
    }

    public int getNumberOfAxes() {
        return this.axis.length;
    }

    public void setAxis(int index, int dimension) {
        if (this.axis[index] != dimension) {
            this.axis[index] = dimension;
        }
        this.repaint();
    }

    public int getAxis(int index) {
        return this.axis[index];
    }

    public boolean canHandleDrawAmount() {
        return false;
    }

    public void setDrawAmount(int amount) {
    }

    public void setPlotColumn(int index, boolean plot) {
        if (this.columns[index] != plot) {
            this.columns[index] = plot;
        }
        this.repaint();
    }

    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    public boolean hasOptionsDialog() {
        return true;
    }

    public void showOptionsDialog() {
        this.gnuPlotDialog.setVisible(true);
    }

    public void setDrawRangeInPlotterSpace(double drawMinX, double drawMaxX, double drawMinY, double drawMaxY) {
    }

    public Point2D getPositionInDataSpace(Point point) {
        return null;
    }

    public void setDrawRange(double drawMinX, double drawMaxX, double drawMinY, double drawMaxY) {
    }

    public void setMousePosInDataSpace(int x, int y) {
    }

    public String getIdForPos(int x, int y) {
        return null;
    }

    public void setDragBounds(int dragX, int dragY, int dragWidth, int dragHeight) {
    }

    private int[] getZ() {
        int count = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i]) continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        int[] z = new int[count];
        int j = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i]) continue;
            z[j++] = i;
        }
        return z;
    }

    private void createGNUPlot(Graphics graphics) {
        int[] z = this.getZ();
        if (z != null && this.axis[0] >= 0) {
            try {
                this.cachedImage = this.statistics.createGNUPlot(this.axis[0], this.axis[1], z, this.gnuPlotDialog.getLineType(), this.gnuPlotDialog.getGNUPlotCommands() + "\n" + "set view " + this.rotX + "," + this.rotZ + "");
            }
            catch (Exception e) {
                SwingTools.showSimpleErrorMessage("Error executing gnuplot", e);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.createGNUPlot(graphics);
        if (this.cachedImage != null) {
            graphics.drawImage(this.cachedImage, 0, 0, null);
        }
    }

    private class RotationListener
    extends MouseAdapter
    implements MouseMotionListener {
        private Point dragStart;
        private int rotXStart;
        private int rotZStart;

        private RotationListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.dragStart = e.getPoint();
            this.rotXStart = GnuPlotPlotter.this.rotX;
            this.rotZStart = GnuPlotPlotter.this.rotZ;
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            GnuPlotPlotter.this.rotX = (this.rotXStart + (int)(this.dragStart.getY() - (double)e.getY())) % 180;
            if (GnuPlotPlotter.this.rotX < 0) {
                GnuPlotPlotter.this.rotX += 180;
            }
            GnuPlotPlotter.this.rotZ = (this.rotZStart + (int)(this.dragStart.getX() - (double)e.getX())) % 360;
            if (GnuPlotPlotter.this.rotZ < 0) {
                GnuPlotPlotter.this.rotZ += 360;
            }
            GnuPlotPlotter.this.statisticsUpdated(null);
        }
    }
}

