/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.Plotter;
import edu.udo.cs.yale.gui.YaleGUI;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class GNUPlotDialog
extends JDialog {
    private static final String[] LINE_TYPES = new String[]{"linespoints", "lines", "points", "impulses", "dots", "steps", "fsteps", "histeps", "errorbars", "xerrorbars", "yerrorbars", "xyerrorbars", "boxes", "boxerrorbars", "boxxyerrorbars", "financebars", "candlesticks", "vector"};
    private JTextArea freeTextArea = new JTextArea(8, 30);
    private JTextField titleField = new JTextField("Created by Yale");
    private JComboBox lineTypes = new JComboBox<String>(LINE_TYPES);
    private JCheckBox gridCheckBox = new JCheckBox("Show grid", true);
    private JCheckBox hiddenCheckBox = new JCheckBox("Hidden 3D");
    private JCheckBox logScaleX = new JCheckBox("Logarithmic scale for X-axis");
    private JCheckBox logScaleY = new JCheckBox("Logarithmic scale for Y-axis");
    private JCheckBox logScaleZ = new JCheckBox("Logarithmic scale for Z-axis");
    private Plotter plotter;

    public GNUPlotDialog(Plotter plotter) {
        super(YaleGUI.getMainFrame(), "Gnuplot options", false);
        this.plotter = plotter;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel contents = new JPanel(gbl);
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridwidth = -1;
        JLabel label = new JLabel("Title");
        gbl.setConstraints(label, c);
        contents.add(label);
        c.gridwidth = 0;
        c.weightx = 1.0;
        gbl.setConstraints(this.titleField, c);
        contents.add(this.titleField);
        c.weightx = 0.0;
        gbl.setConstraints(this.lineTypes, c);
        contents.add(this.lineTypes);
        gbl.setConstraints(this.gridCheckBox, c);
        contents.add(this.gridCheckBox);
        gbl.setConstraints(this.hiddenCheckBox, c);
        contents.add(this.hiddenCheckBox);
        gbl.setConstraints(this.logScaleX, c);
        contents.add(this.logScaleX);
        gbl.setConstraints(this.logScaleY, c);
        contents.add(this.logScaleY);
        gbl.setConstraints(this.logScaleZ, c);
        contents.add(this.logScaleZ);
        label = new JLabel("Additional gnuplot commands");
        gbl.setConstraints(label, c);
        contents.add(label);
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane freeTextAreaPane = new JScrollPane(this.freeTextArea);
        gbl.setConstraints(freeTextAreaPane, c);
        contents.add(freeTextAreaPane);
        contents.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        this.getContentPane().add((Component)contents, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton hide = new JButton("Hide");
        buttonPanel.add(hide);
        hide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GNUPlotDialog.this.setVisible(false);
            }
        });
        JButton update = new JButton("Update");
        buttonPanel.add(update);
        update.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GNUPlotDialog.this.plotter.statisticsUpdated(null);
            }
        });
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
    }

    public String getGNUPlotCommands() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("set title \"" + this.titleField.getText() + "\"\n");
        if (this.gridCheckBox.isSelected()) {
            buffer.append("set grid\n");
        }
        if (this.hiddenCheckBox.isSelected()) {
            buffer.append("set hidden3d\n");
        }
        if (this.logScaleX.isSelected()) {
            buffer.append("set logscale x\n");
        }
        if (this.logScaleY.isSelected()) {
            buffer.append("set logscale y\n");
        }
        if (this.logScaleZ.isSelected()) {
            buffer.append("set logscale z\n");
        }
        buffer.append(this.freeTextArea.getText() + "\n");
        return buffer.toString();
    }

    public String getLineType() {
        return LINE_TYPES[this.lineTypes.getSelectedIndex()];
    }
}

