/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.operator.ExperimentStoppedException;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Toolkit;

public class ExperimentThread
extends Thread {
    private Experiment experiment;

    public ExperimentThread(Experiment experiment) {
        this.experiment = experiment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block7: {
            IOContainer results = null;
            try {
                this.experiment.prepareRun();
                YaleGUI.getMainFrame().getResultDisplay().clear();
                YaleGUI.getMainFrame().getResultDisplay().setStatistics(this.experiment.getStatistics());
                results = this.experiment.run();
                ExperimentThread.beep("success");
                this.experiment.getRootOperator().sendEmail(results, null);
                this.experiment.tearDown();
                YaleGUI.getMainFrame().experimentEnded(results);
            }
            catch (ExperimentStoppedException ex) {
                ExperimentThread.beep("error");
                LogService.logMessage(ex.getMessage(), 8);
            }
            catch (Throwable e) {
                ExperimentThread.beep("error");
                LogService.logException(null, e);
                LogService.logMessageWithTree("Experiment failed!", 7, this.experiment.getCurrentOperator());
                this.experiment.getRootOperator().sendEmail(null, e);
                SwingTools.showErrorMessage("Experiment failed", e);
                this.experiment.tearDown();
                YaleGUI.getMainFrame().experimentEnded(results);
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.experiment.tearDown();
                YaleGUI.getMainFrame().experimentEnded(results);
            }
        }
    }

    public static void beep(String reason) {
        if (Tools.booleanValue(System.getProperty("yale.gui.beep." + reason), false)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void stopExperiment() {
        this.experiment.stop();
    }
}

