/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.ExperimentEditor;
import edu.udo.cs.yale.gui.LeafRenderer;
import edu.udo.cs.yale.gui.OperatorRenderer;
import edu.udo.cs.yale.gui.SimpleChainRenderer;
import edu.udo.cs.yale.gui.WrapperRenderer;
import edu.udo.cs.yale.operator.ExperimentOperator;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.SimpleOperatorChain;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class ExperimentRenderer
extends JPanel
implements ExperimentEditor {
    private Operator operator;
    private static OperatorRenderer leafRenderer = new LeafRenderer();
    private static OperatorRenderer chainRenderer = new SimpleChainRenderer();
    private static OperatorRenderer wrapperRenderer = new WrapperRenderer();

    public void experimentChanged(Operator operator) {
        this.setOperator(operator);
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
        this.repaint();
    }

    public void paint(Graphics g) {
        if (this.operator == null) {
            return;
        }
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g2d = (Graphics2D)g;
        Dimension size = ExperimentRenderer.getRenderer(this.operator).getSize(this.operator, g2d);
        Dimension dimension = new Dimension((int)size.getWidth() + 20, (int)size.getHeight() + 20);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        g2d.translate((double)(this.getWidth() / 2) - size.getWidth() / 2.0, 10.0);
        ExperimentRenderer.getRenderer(this.operator).drawOperator(this.operator, g2d);
    }

    public void print(Graphics g) {
        if (this.operator == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        ExperimentRenderer.getRenderer(this.operator).drawOperator(this.operator, g2d);
    }

    public static OperatorRenderer getRenderer(Operator op) {
        if (op instanceof OperatorChain) {
            if (op instanceof SimpleOperatorChain || op instanceof ExperimentOperator) {
                return chainRenderer;
            }
            return wrapperRenderer;
        }
        return leafRenderer;
    }

    public Component getMainComponent() {
        return this;
    }

    public void validateExperiment() {
    }
}

