/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.ObjectVisualizer;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.gui.YaleGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ExampleVisualizer
implements ObjectVisualizer {
    private JDialog dialog;
    private ExampleSet exampleSet;

    public ExampleVisualizer(ExampleSet exampleSet) {
        this.exampleSet = exampleSet;
    }

    public void init() {
    }

    public void startVisualization(String objId) {
        Attribute attribute;
        this.dialog = new JDialog(YaleGUI.getMainFrame(), "Example: " + objId, false);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        Attribute idAttribute = this.exampleSet.getId();
        double idValue = idAttribute.isNominal() ? (double)idAttribute.mapString(objId) : Double.parseDouble(objId);
        Example example = this.exampleSet.getExampleFromId(idValue);
        StringBuffer exampleText = new StringBuffer("Regular attributes:<br><table>");
        for (int i = 0; i < example.getNumberOfAttributes(); ++i) {
            attribute = example.getAttribute(i);
            exampleText.append("<tr><td>" + attribute.getName() + ": </td><td>" + example.getValue(attribute) + "</td></tr>");
        }
        exampleText.append("</table><br><br>Special attributes:<br><table>");
        Iterator s = example.getSpecialAttributeNames().iterator();
        while (s.hasNext()) {
            attribute = example.getAttribute((String)s.next());
            exampleText.append("<tr><td>" + attribute.getName() + "</td><td>" + example.getValueAsString(attribute) + "</td></tr>");
        }
        exampleText.append("</table>");
        JPanel textPanel = SwingTools.createTextPanel("Example: " + objId, exampleText.toString());
        JScrollPane scrollPane = new JScrollPane(textPanel);
        this.dialog.getContentPane().add((Component)scrollPane, "Center");
        JPanel buttons = new JPanel(new FlowLayout());
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExampleVisualizer.this.dialog.dispose();
            }
        });
        buttons.add(okButton);
        this.dialog.getContentPane().add((Component)buttons, "South");
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(YaleGUI.getMainFrame());
        this.dialog.setVisible(true);
    }

    public void stopVisualization(String objId) {
        this.dialog.dispose();
    }

    public String getTitle(String objId) {
        return objId;
    }

    public boolean isCapableToVisualize(String id) {
        Attribute idAttribute = this.exampleSet.getId();
        double idValue = idAttribute.isNominal() ? (double)idAttribute.mapString(id) : Double.parseDouble(id);
        return this.exampleSet.getExampleFromId(idValue) != null;
    }
}

