/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.StatisticsRow;
import edu.udo.cs.yale.gui.Plotter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;

public class DistributionPlotter
extends JPanel
implements Plotter {
    private static Icon[] RECTANGLE_STYLE_ICONS;
    private static final Color[] RECTANGLE_COLORS;
    public static final RectangleStyle[] RECTANGLE_STYLES;
    private static final int[] TICS;
    private static final Font LABEL_FONT;
    private static final Color GRID_COLOR;
    private static final int MARGIN = 20;
    private static final int LABEL_MARGIN_X = 15;
    private static final int LABEL_MARGIN_Y = 50;
    private Statistics statistics;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double xTicSize;
    private double yTicSize;
    private double drawMinX = Double.NEGATIVE_INFINITY;
    private double drawMaxX = Double.POSITIVE_INFINITY;
    private double drawMinY = Double.NEGATIVE_INFINITY;
    private double drawMaxY = Double.POSITIVE_INFINITY;
    private int column = -1;
    private Bins bins = null;
    private int drawAmount = 100;

    public DistributionPlotter() {
        this.setBackground(Color.white);
    }

    public DistributionPlotter(Statistics statistics) {
        this();
        this.setStatistics(statistics);
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
        statistics.addStatisticsListener(this);
        this.prepareData();
    }

    public Component getPlotter() {
        return this;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public String getAxisName(int index) {
        return "none";
    }

    public int getValuePlotSelectionType() {
        return 0;
    }

    public Icon getIcon(int index) {
        return RECTANGLE_STYLE_ICONS[index % RECTANGLE_STYLE_ICONS.length];
    }

    public void statisticsUpdated(Statistics source) {
        this.repaint();
    }

    public boolean isSaveable() {
        return false;
    }

    public void save() {
    }

    public int getNumberOfAxes() {
        return 0;
    }

    public void setAxis(int index, int dimension) {
    }

    public int getAxis(int index) {
        return -1;
    }

    public boolean canHandleDrawAmount() {
        return true;
    }

    public void setDrawAmount(int amount) {
        this.drawAmount = amount;
        this.repaint();
    }

    public void setPlotColumn(int index, boolean plot) {
        if (plot) {
            this.column = index;
        }
        this.repaint();
    }

    public boolean getPlotColumn(int index) {
        return this.column == index;
    }

    public boolean hasOptionsDialog() {
        return false;
    }

    public void showOptionsDialog() {
    }

    public void setDrawRangeInPlotterSpace(double drawMinX, double drawMaxX, double drawMinY, double drawMaxY) {
    }

    public Point2D getPositionInDataSpace(Point point) {
        return null;
    }

    public void setDrawRange(double drawMinX, double drawMaxX, double drawMinY, double drawMaxY) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareData() {
        this.minY = Double.POSITIVE_INFINITY;
        this.minX = Double.POSITIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        if (this.column < 0) {
            this.bins = null;
            return;
        }
        double[] data = new double[this.statistics.getNumberOfRows()];
        int index = 0;
        Statistics statistics = this.statistics;
        synchronized (statistics) {
            Iterator i = this.statistics.iterator();
            while (i.hasNext()) {
                StatisticsRow statRow = (StatisticsRow)i.next();
                Object[] row = statRow.getRow();
                try {
                    if (row[this.column] != null) {
                        data[index] = Double.parseDouble(row[this.column].toString());
                        this.minX = Math.min(data[index], this.minX);
                        this.maxX = Math.max(data[index], this.maxX);
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Not a numerical data column: " + this.column);
                }
                ++index;
            }
        }
        this.bins = new Bins(this.column, this.minX, this.maxX, this.drawAmount);
        for (int i = 0; i < data.length; ++i) {
            this.bins.addPoint(data[i]);
        }
        this.maxY = Math.max((double)this.bins.getMaxCounter(), this.maxY);
        this.minY = 0.0;
        if (this.statistics.getNumberOfRows() == 0) {
            this.minY = 0.0;
            this.minX = 0.0;
            this.maxY = 1.0;
            this.maxX = 1.0;
        }
        if (this.minX == this.maxX) {
            this.minX -= 0.5;
            this.maxX += 0.5;
        }
        if (this.minY == this.maxY) {
            this.minY -= 0.5;
            this.maxY += 0.5;
        }
        this.xTicSize = this.getTicSize(this.minX, this.maxX);
        this.yTicSize = this.getTicSize(this.minY, this.maxY);
        this.minX = Math.floor(this.minX / this.xTicSize) * this.xTicSize;
        this.maxX = Math.ceil(this.maxX / this.xTicSize) * this.xTicSize;
        this.minY = Math.floor(this.minY / this.yTicSize) * this.yTicSize;
        this.maxY = Math.ceil(this.maxY / this.yTicSize) * this.yTicSize;
    }

    public void setMousePosInDataSpace(int x, int y) {
    }

    public String getIdForPos(int x, int y) {
        return null;
    }

    public void setDragBounds(int dragX, int dragY, int dragWidth, int dragHeight) {
    }

    private double getTicSize(double min, double max) {
        double delta = (max - min) / 5.0;
        double e = Math.floor(Math.log(delta) / Math.log(10.0));
        double factor = Math.pow(10.0, e);
        for (int i = TICS.length - 1; i >= 0; --i) {
            if (!((double)TICS[i] * factor <= delta)) continue;
            return (double)TICS[i] * factor;
        }
        return factor;
    }

    private void drawBins(Graphics2D g, double dx, double dy, double sx, double sy) {
        if (this.bins == null) {
            return;
        }
        if (this.bins.getMaxCounter() > 0) {
            this.bins.getRectangleStyle().set(g);
            Iterator i = this.bins.getIterator();
            while (i.hasNext()) {
                Bin bin = (Bin)i.next();
                Rectangle2D.Double rectangle = new Rectangle2D.Double((bin.getLeft() + dx) * sx, dy * sy, (bin.getRight() - bin.getLeft()) * sx, (double)bin.getCounter() * sy);
                g.fill(rectangle);
            }
        }
    }

    private void drawGrid(Graphics2D g, double dx, double dy, double sx, double sy) {
        DecimalFormat format = new DecimalFormat("0.00E0");
        g.setFont(LABEL_FONT);
        g.setStroke(new BasicStroke(1.0f));
        for (int i = 0; i < 14; ++i) {
            double x = (double)i * this.xTicSize + this.minX;
            double y = (double)i * this.yTicSize + this.minY;
            g.setColor(GRID_COLOR);
            g.draw(new Line2D.Double((x + dx) * sx, (this.minY + dy) * sy, (x + dx) * sx, (this.maxY + dy) * sy));
            g.draw(new Line2D.Double((this.minX + dx) * sx, (y + dy) * sy, (this.maxX + dx) * sx, (y + dy) * sy));
            g.setColor(Color.black);
            String label = format.format(y) + " ";
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(label, g.getFontRenderContext());
            g.drawString(label, (float)((this.minX + dx) * sx - stringBounds.getWidth()), (float)((y + dy) * sy - stringBounds.getHeight() / 2.0 - stringBounds.getY()));
            label = format.format(x);
            stringBounds = LABEL_FONT.getStringBounds(label, g.getFontRenderContext());
            g.drawString(label, (float)((x + dx) * sx - stringBounds.getWidth() / 2.0), (float)((this.minY + dy) * sy + stringBounds.getHeight()));
        }
    }

    private void draw(Graphics2D g, int pixWidth, int pixHeight) {
        double sx = 0.0;
        double sy = 0.0;
        sx = ((double)pixWidth - 50.0) / (this.maxX - this.minX);
        sy = ((double)pixHeight - 15.0) / (this.maxY - this.minY);
        Graphics2D coordinateSpace = (Graphics2D)g.create();
        coordinateSpace.translate(50, 15);
        if (Double.isNaN(sx) || Double.isNaN(sy)) {
            coordinateSpace.scale(1.0, -1.0);
            coordinateSpace.drawString("No data points available (yet).", 0, -20);
            coordinateSpace.drawString("Zooming out with a right click might help.", 0, 0);
        } else {
            this.drawGrid(coordinateSpace, -this.minX, -this.minY, sx, sy);
            this.drawBins(coordinateSpace, -this.minX, -this.minY, sx, sy);
        }
        coordinateSpace.dispose();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintBins(graphics);
    }

    private void paintBins(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        int pixWidth = this.getWidth() - 40;
        int pixHeight = this.getHeight() - 40;
        Graphics2D scaled = (Graphics2D)g.create();
        scaled.translate(20, 20);
        scaled.translate(0, pixHeight + 1);
        this.prepareData();
        if (this.bins == null) {
            scaled.drawString("No plots selected.", 0, 0);
        } else {
            scaled.scale(1.0, -1.0);
            g.setColor(Color.black);
            this.draw(scaled, pixWidth, pixHeight);
        }
        scaled.dispose();
    }

    public Iterator getBins() {
        return this.bins.getIterator();
    }

    static {
        int i;
        RECTANGLE_COLORS = new Color[]{Color.black, Color.red, Color.blue, Color.orange, new Color(0, 200, 0), Color.pink, Color.yellow, Color.gray};
        RECTANGLE_STYLES = new RectangleStyle[RECTANGLE_COLORS.length];
        for (i = 0; i < RECTANGLE_COLORS.length; ++i) {
            DistributionPlotter.RECTANGLE_STYLES[i] = new RectangleStyle(RECTANGLE_COLORS[i]);
        }
        RECTANGLE_STYLE_ICONS = new RectangleStyleIcon[RECTANGLE_STYLES.length];
        for (i = 0; i < RECTANGLE_STYLE_ICONS.length; ++i) {
            DistributionPlotter.RECTANGLE_STYLE_ICONS[i] = new RectangleStyleIcon(i);
        }
        TICS = new int[]{1, 2, 5};
        LABEL_FONT = new Font("Lucida Sans", 0, 11).deriveFont(AffineTransform.getScaleInstance(1.0, -1.0));
        GRID_COLOR = Color.lightGray;
    }

    public class Bin {
        private double left;
        private double right;
        private int counter = 0;

        public Bin(double left, double right) {
            this.left = left;
            this.right = right;
        }

        public boolean contains(double position) {
            return position >= this.left && position <= this.right + 1.0E-8;
        }

        public int addPoint() {
            ++this.counter;
            return this.counter;
        }

        public int getCounter() {
            return this.counter;
        }

        public double getRight() {
            return this.right;
        }

        public double getLeft() {
            return this.left;
        }

        public String toString() {
            return "(" + this.left + "," + this.right + ") = " + this.counter;
        }
    }

    private class Bins {
        private int styleIndex;
        private int maxCounter = 0;
        private List bins = new LinkedList();

        private Bins(int styleIndex, double left, double right, int number) {
            this.styleIndex = styleIndex;
            double delta = (right - left) / (double)number;
            double start = left;
            for (int i = 0; i < number; ++i) {
                this.bins.add(new Bin(start, start + delta));
                start += delta;
            }
        }

        private RectangleStyle getRectangleStyle() {
            return RECTANGLE_STYLES[this.styleIndex % RECTANGLE_STYLES.length];
        }

        public void addPoint(double position) {
            Iterator i = this.bins.iterator();
            while (i.hasNext()) {
                Bin bin = (Bin)i.next();
                if (!bin.contains(position)) continue;
                int counter = bin.addPoint();
                this.maxCounter = Math.max(this.maxCounter, counter);
                break;
            }
        }

        public int getMaxCounter() {
            return this.maxCounter;
        }

        public Iterator getIterator() {
            return this.bins.iterator();
        }

        public String toString() {
            return this.bins.toString();
        }
    }

    private static class RectangleStyle {
        private Color color;

        private RectangleStyle(Color color) {
            this.color = color;
        }

        public void set(Graphics2D g) {
            g.setColor(this.color);
        }
    }

    private static class RectangleStyleIcon
    implements Icon {
        private int index;

        private RectangleStyleIcon(int index) {
            this.index = index;
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            RECTANGLE_STYLES[this.index].set((Graphics2D)g);
            g.fillRect(x, y, 16, 16);
            g.setColor(Color.black);
            g.drawRect(x, y, 16, 16);
        }
    }
}

