/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.tools.LogService;
import java.util.ArrayList;
import java.util.List;

public abstract class SingularNumericalGenerator
extends FeatureGenerator {
    private static final Attribute[] INPUT_ATTR = new Attribute[]{AttributeFactory.createAttribute(2)};

    public abstract double calculateValue(double var1);

    public Attribute[] getInputAttributes() {
        return INPUT_ATTR;
    }

    public Attribute[] getOutputAttributes(ExampleTable input) {
        Attribute a1 = this.getArgument(0);
        Attribute ao = AttributeFactory.createAttribute(2, 3, -1, this.getFunction(), new Attribute[]{a1}, null);
        return new Attribute[]{ao};
    }

    public List getInputCandidates(ExampleSet exampleSet, int maxDepth, String[] functions) {
        ArrayList<Attribute[]> result = new ArrayList<Attribute[]>();
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            Attribute attribute = exampleSet.getAttribute(i);
            if (!this.checkCompatibility(attribute, INPUT_ATTR[0], maxDepth, functions)) continue;
            result.add(new Attribute[]{attribute});
        }
        return result;
    }

    public void generate(DataRow data) throws GenerationException {
        try {
            Attribute a = this.getArgument(0);
            double value = data.get(a);
            double r = this.calculateValue(value);
            if (Double.isInfinite(r)) {
                LogService.logMessage(this.getFunction() + ": Infinite value generated.", 4);
                throw new GenerationException(this.getFunction() + ": Infinite value generated.");
            }
            if (Double.isNaN(r)) {
                LogService.logMessage(this.getFunction() + ": NaN generated.", 4);
                throw new GenerationException(this.getFunction() + ": NaN generated.");
            }
            if (this.resultAttributes[0] != null) {
                data.set(this.resultAttributes[0], r);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new GenerationException("a:" + this.getArgument(0), ex);
        }
    }

    public String toString() {
        String s = "singular function ";
        if (this.resultAttributes != null && this.resultAttributes.length > 0 && this.resultAttributes[0] != null) {
            s = s + this.resultAttributes[0].getName() + ":=";
        }
        s = s + this.getFunction() + "(";
        if (this.argumentsSet()) {
            s = s + this.getArgument(0).getName();
        }
        s = s + ")";
        return s;
    }
}

