/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.generator.SingularNumericalGenerator;
import edu.udo.cs.yale.tools.LogService;

public class NormalizationGenerator
extends SingularNumericalGenerator {
    public static final String FUNCTION_NAME = "norm";
    private double min;
    private double max;

    public NormalizationGenerator() {
        this(0.0, 0.1);
    }

    public NormalizationGenerator(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public FeatureGenerator newInstance() {
        return new NormalizationGenerator();
    }

    public double calculateValue(double value) {
        return Double.NaN;
    }

    public void generate(DataRow data) throws GenerationException {
        try {
            Attribute a = this.getArgument(0);
            double value = data.get(a);
            double minA = a.getMinimum();
            double maxA = a.getMaximum();
            double result = 0.0;
            if (maxA - minA != 0.0 && this.max - this.min != 0.0) {
                result = (value - minA) / (maxA - minA) * (this.max - this.min) + this.min;
            }
            if (this.resultAttributes[0] != null) {
                data.set(this.resultAttributes[0], result);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new GenerationException("a1:" + this.getArgument(0));
        }
    }

    public void setFunction(String name) {
        if (!FUNCTION_NAME.equals(name)) {
            LogService.logMessage("Illegal function name '" + name + "' for " + this.getClass().getName() + ".", 6);
        }
    }

    public String getFunction() {
        return FUNCTION_NAME;
    }
}

