/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.tools.LogService;
import java.util.ArrayList;
import java.util.List;

public abstract class BinaryNumericalGenerator
extends FeatureGenerator {
    private static final Attribute[] INPUT_ATTR = new Attribute[]{AttributeFactory.createAttribute(2), AttributeFactory.createAttribute(2)};

    public abstract double calculateValue(double var1, double var3);

    public abstract boolean isCommutative();

    public abstract boolean isSelfApplicable();

    public Attribute[] getInputAttributes() {
        return INPUT_ATTR;
    }

    public Attribute[] getOutputAttributes(ExampleTable input) {
        Attribute a1 = this.getArgument(0);
        Attribute a2 = this.getArgument(1);
        Attribute ao = AttributeFactory.createAttribute(2, 3, -1, this.getFunction(), new Attribute[]{a1, a2}, null);
        return new Attribute[]{ao};
    }

    public List getInputCandidates(ExampleSet exampleSet, int maxDepth, String[] functions) {
        ArrayList<Attribute[]> result;
        block11: {
            block14: {
                block13: {
                    block12: {
                        block10: {
                            result = new ArrayList<Attribute[]>();
                            if (BinaryNumericalGenerator.getSelectionMode() != SELECTION_MODE_ALL) break block10;
                            for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
                                Attribute first = exampleSet.getAttribute(i);
                                if (!this.checkCompatibility(first, INPUT_ATTR[0], maxDepth, functions)) continue;
                                for (int j = 0; j < exampleSet.getNumberOfAttributes(); ++j) {
                                    Attribute second = exampleSet.getAttribute(j);
                                    if (!this.checkCompatibility(second, INPUT_ATTR[1], maxDepth, functions)) continue;
                                    result.add(new Attribute[]{first, second});
                                }
                            }
                            break block11;
                        }
                        if (!this.isCommutative() || !this.isSelfApplicable()) break block12;
                        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
                            Attribute first = exampleSet.getAttribute(i);
                            if (!this.checkCompatibility(first, INPUT_ATTR[0], maxDepth, functions)) continue;
                            for (int j = i; j < exampleSet.getNumberOfAttributes(); ++j) {
                                Attribute second = exampleSet.getAttribute(j);
                                if (!this.checkCompatibility(second, INPUT_ATTR[1], maxDepth, functions)) continue;
                                result.add(new Attribute[]{first, second});
                            }
                        }
                        break block11;
                    }
                    if (!this.isCommutative() || this.isSelfApplicable()) break block13;
                    for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
                        Attribute first = exampleSet.getAttribute(i);
                        if (!this.checkCompatibility(first, INPUT_ATTR[0], maxDepth, functions)) continue;
                        for (int j = i + 1; j < exampleSet.getNumberOfAttributes(); ++j) {
                            Attribute second = exampleSet.getAttribute(j);
                            if (!this.checkCompatibility(second, INPUT_ATTR[1], maxDepth, functions)) continue;
                            result.add(new Attribute[]{first, second});
                        }
                    }
                    break block11;
                }
                if (this.isCommutative() || !this.isSelfApplicable()) break block14;
                for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
                    Attribute first = exampleSet.getAttribute(i);
                    if (!this.checkCompatibility(first, INPUT_ATTR[0], maxDepth, functions)) continue;
                    for (int j = 0; j < exampleSet.getNumberOfAttributes(); ++j) {
                        Attribute second = exampleSet.getAttribute(j);
                        if (!this.checkCompatibility(second, INPUT_ATTR[1], maxDepth, functions)) continue;
                        result.add(new Attribute[]{first, second});
                    }
                }
                break block11;
            }
            if (this.isCommutative() || this.isSelfApplicable()) break block11;
            for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
                Attribute first = exampleSet.getAttribute(i);
                if (!this.checkCompatibility(first, INPUT_ATTR[0], maxDepth, functions)) continue;
                for (int j = 0; j < exampleSet.getNumberOfAttributes(); ++j) {
                    Attribute second;
                    if (i == j || !this.checkCompatibility(second = exampleSet.getAttribute(j), INPUT_ATTR[1], maxDepth, functions)) continue;
                    result.add(new Attribute[]{first, second});
                }
            }
        }
        return result;
    }

    public void generate(DataRow data) throws GenerationException {
        try {
            Attribute a0 = this.getArgument(0);
            Attribute a1 = this.getArgument(1);
            double o1 = data.get(a0);
            double o2 = data.get(a1);
            double r = this.calculateValue(o1, o2);
            if (Double.isInfinite(r)) {
                LogService.logMessage(this.getFunction() + ": Infinite value generated.", 4);
                throw new GenerationException(this.getFunction() + ": Infinite value generated.");
            }
            if (Double.isNaN(r)) {
                LogService.logMessage(this.getFunction() + ": NaN generated.", 4);
                throw new GenerationException(this.getFunction() + ": NaN generated.");
            }
            if (this.resultAttributes[0] != null) {
                data.set(this.resultAttributes[0], r);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new GenerationException("a1:" + this.getArgument(0) + " a2: " + this.getArgument(1), ex);
        }
    }

    public String toString() {
        String s = "binary function (";
        if (this.resultAttributes != null && this.resultAttributes.length > 0 && this.resultAttributes[0] != null) {
            s = s + this.resultAttributes[0].getName() + ":=";
        }
        if (this.argumentsSet()) {
            s = s + this.getArgument(0).getName() + " ";
        }
        s = s + this.getFunction();
        if (this.argumentsSet()) {
            s = s + " " + this.getArgument(1).getName();
        }
        s = s + ")";
        return s;
    }
}

