/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.WeightApplier;
import java.util.Map;

public class WeightingExampleReader
implements ExampleReader {
    private ExampleReader parentReader;
    private Attribute[] selectedAttributes;
    private Map specialAttributes;
    private AttributeWeights weights;
    private WeightApplier weightApplier;

    public WeightingExampleReader(ExampleReader er, ExampleSet exampleSet, AttributeWeights weights, WeightApplier weightApplier) {
        this.parentReader = er;
        this.weights = weights;
        this.weightApplier = weightApplier;
        this.specialAttributes = exampleSet.getSpecialAttributes();
        this.selectedAttributes = new Attribute[exampleSet.getNumberOfAttributes()];
        for (int i = 0; i < this.selectedAttributes.length; ++i) {
            this.selectedAttributes[i] = exampleSet.getAttribute(i);
        }
    }

    public boolean hasNext() {
        return this.parentReader.hasNext();
    }

    public Example next() {
        if (!this.hasNext()) {
            return null;
        }
        Example example = this.parentReader.next();
        if (example == null) {
            return null;
        }
        return new Example(example.getDataRow(), this.selectedAttributes, this.specialAttributes, this.weights, this.weightApplier);
    }
}

