/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SimpleExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class ExampleTable {
    private int currentlyHighestBlockNr = 1000;
    private List attributes = new ArrayList();
    private List unusedColumnList = new LinkedList();
    private boolean sparse = false;

    public abstract int getSize();

    public abstract DataRowReader getDataReader();

    public abstract DataRow getDataRow(int var1);

    public ExampleTable(List attributes) {
        this.addAttributes(attributes);
    }

    public void setSparse(boolean sparse) {
        this.sparse = sparse;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public Attribute[] getAttributes() {
        Attribute[] attribute = new Attribute[this.attributes.size()];
        this.attributes.toArray(attribute);
        return attribute;
    }

    public Attribute getAttribute(int i) {
        return (Attribute)this.attributes.get(i);
    }

    public Attribute findAttribute(String name) throws OperatorException {
        if (name == null) {
            return null;
        }
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Attribute att = (Attribute)i.next();
            if (att == null || !att.getName().equals(name)) continue;
            return att;
        }
        throw new UserError(null, 111, name);
    }

    public void addAttributes(Collection newAttributes) {
        Iterator i = newAttributes.iterator();
        while (i.hasNext()) {
            this.addAttribute((Attribute)i.next());
        }
    }

    public int addAttribute(Attribute a) {
        int index = -1;
        if (this.unusedColumnList.size() > 0) {
            index = (Integer)this.unusedColumnList.remove(0);
            LogService.logMessage("Reusing data column " + index + ".", 0);
            this.attributes.set(index, a);
        } else {
            index = this.attributes.size();
            this.attributes.add(a);
        }
        a.setTableIndex(index);
        return index;
    }

    public void removeAttribute(Attribute attribute) {
        this.removeAttribute(attribute.getTableIndex());
    }

    public void removeAttribute(int index) {
        Attribute a = (Attribute)this.attributes.get(index);
        if (a == null) {
            return;
        }
        LogService.logMessage("Removing attribute '" + a.getName() + "'. Column " + a.getTableIndex() + " will be reused.", 0);
        this.attributes.set(index, null);
        this.unusedColumnList.add(new Integer(index));
    }

    protected int getNumberOfAttributes() {
        return this.attributes.size();
    }

    public int getAttributeCount() {
        return this.attributes.size() - this.unusedColumnList.size();
    }

    public int getHighestBlockNr() {
        return this.currentlyHighestBlockNr;
    }

    public int getNextFreeBlockNr() {
        return ++this.currentlyHighestBlockNr;
    }

    public int getBlockEndIndex(int startindex) {
        int blockNumber = this.getAttribute(startindex).getBlockNumber();
        if (blockNumber != -1) {
            for (int i = startindex + 1; i < this.getNumberOfAttributes(); ++i) {
                Attribute att = this.getAttribute(i);
                if (att != null && att.getBlockNumber() == blockNumber) continue;
                return i - 1;
            }
            return this.getNumberOfAttributes() - 1;
        }
        return startindex;
    }

    public Attribute getAttribute(Attribute attribute) {
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            Attribute a = this.getAttribute(i);
            if (a == null || !a.equalConstructionDescription(attribute)) continue;
            return a;
        }
        return null;
    }

    public ExampleSet createExampleSet(AttributeSet attributeSet) {
        SimpleExampleSet exampleSet = new SimpleExampleSet(this, attributeSet.getRegularAttributes());
        Iterator i = attributeSet.getSpecialNames().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            exampleSet.setSpecialAttribute(name, attributeSet.getSpecialAttribute(name));
        }
        exampleSet.remapAllIds();
        return exampleSet;
    }

    public ExampleSet createCompleteExampleSet(Attribute label, Attribute predictedLabel, Attribute weight, Attribute idAttribute) {
        return new SimpleExampleSet(this, label, predictedLabel, weight, idAttribute);
    }

    public ExampleSet createCompleteExampleSet(Map specialAttributes) {
        return new SimpleExampleSet(this, specialAttributes);
    }

    public String toString() {
        return "ExampleTable: " + this.attributes.size() + " attributes:" + this.attributes;
    }

    public String toDataString() {
        StringBuffer result = new StringBuffer(this.toString() + "\n");
        DataRowReader reader = this.getDataReader();
        while (reader.hasNext()) {
            result.append(reader.next().toString() + "\n");
        }
        return result.toString();
    }
}

