/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Condition;
import edu.udo.cs.yale.example.ConditionExampleReader;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleSetAdapter;

public class ConditionedExampleSet
extends ExampleSetAdapter {
    private Condition condition;
    private int size = -1;
    private int[] mapping;

    public ConditionedExampleSet(ExampleSet parent, Condition condition) {
        super(parent);
        if (condition == null) {
            throw new IllegalArgumentException("Condition must not be null!");
        }
        this.condition = condition;
        this.updateCondition();
    }

    public ConditionedExampleSet(ConditionedExampleSet exampleSet) {
        super(exampleSet);
        this.condition = exampleSet.condition.duplicate();
        this.size = exampleSet.size;
        this.mapping = new int[exampleSet.mapping.length];
        System.arraycopy(exampleSet.mapping, 0, this.mapping, 0, exampleSet.mapping.length);
    }

    public void updateCondition() {
        ExampleReader reader = this.getExampleReader();
        this.size = 0;
        while (reader.hasNext()) {
            ++this.size;
            reader.next();
        }
        this.mapping = new int[this.size];
        int exampleCounter = 0;
        int conditionCounter = 0;
        reader = super.getExampleReader();
        while (reader.hasNext()) {
            Example example = reader.next();
            if (this.condition.conditionOk(example)) {
                this.mapping[conditionCounter++] = exampleCounter;
            }
            ++exampleCounter;
        }
    }

    public ExampleReader getExampleReader() {
        return new ConditionExampleReader(super.getExampleReader(), this.condition);
    }

    public Example getExample(int index) {
        if (index < 0 || index >= this.mapping.length) {
            throw new RuntimeException("Given index '" + index + "' does not fit the filtered ExampleSet!");
        }
        return super.getExample(this.mapping[index]);
    }

    public int getSize() {
        return this.size;
    }
}

