/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.doc;

import edu.udo.cs.yale.doc.AbstractOperatorDocGenerator;
import edu.udo.cs.yale.tools.LogService;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LatexOperatorDocGenerator
extends AbstractOperatorDocGenerator {
    public static final String[][] TAGS = new String[][]{{"", ""}, {"\\operator{", "}"}, {"\\group{", "}"}, {"\n\\begin{parameters}", "\\end{parameters}"}, {"", ""}, {"\\reqpar[", "]"}, {"\\optpar[", "]"}, {"", ""}, {"\\paragraph{Short description:} ", ""}, {"\\opdescr ", ""}, {"\\begin{opin} ", "\\end{opin}"}, {"\\begin{opout} ", "\\end{opout}"}, {"\\item[", "]"}, {"\n\\begin{values}", "\\end{values}"}, {"", ""}, {"\\val[", "]"}, {"", ""}, {"\\index{", "}"}, {"\\par References: ", ""}, {"\\cite{", "}"}, {"\\emph{", "}\n"}, {"\\paragraph{Learner capabilities:}", "\n"}};

    public String getOpenTag(int tagNo) {
        return TAGS[tagNo][0];
    }

    public String getCloseTag(int tagNo) {
        return TAGS[tagNo][1];
    }

    public String marginIcon(String iconName) {
        String epsfig = "\\epsfig{file=graphics/" + iconName + ".eps}";
        return "\\marginpar[\\flushright" + epsfig + "]{" + epsfig + "}";
    }

    public String escape(String toEscape) {
        String escaped = toEscape;
        escaped = escaped.replaceAll("_", "\\\\_");
        escaped = escaped.replaceAll("\\$", "\\\\\\$");
        escaped = escaped.replaceAll("\u221e", "\\$\\\\infty\\$");
        escaped = escaped.replaceAll("&auml;", "\\\\\"a");
        escaped = escaped.replaceAll("&ouml;", "\\\\\"o");
        escaped = escaped.replaceAll("&uuml;", "\\\\\"u");
        escaped = escaped.replaceAll("&Auml;", "\\\\\"A");
        escaped = escaped.replaceAll("&Ouml;", "\\\\\"O");
        escaped = escaped.replaceAll("&Uuml;", "\\\\\"U");
        escaped = escaped.replaceAll("&szlig;", "\\\\\"s");
        escaped = escaped.replaceAll("&nbsp;", "\\\\ ");
        escaped = escaped.replaceAll("(\\w)&quot;", "$1''");
        escaped = escaped.replaceAll("&quot;", "``");
        escaped = escaped.replaceAll("#", "\\\\#");
        escaped = escaped.replaceAll("\\[", "\\{\\[\\}");
        escaped = escaped.replaceAll("\\]", "\\{\\]\\}");
        escaped = escaped.replaceAll("Yale", "\\\\Yale");
        escaped = escaped.replaceAll("\\\\s", "\\$\\\\backslash\\$s");
        escaped = escaped.replaceAll("\\\\t", "\\$\\\\backslash\\$t");
        escaped = escaped.replaceAll("\\|", "\\$|\\$");
        return escaped;
    }

    public void beginGroup(String groupName, PrintWriter out) {
        out.println("\\pagebreak[4]");
        groupName = groupName.replace(' ', '_');
        out.println("\\input{OpGroup" + groupName + ".tex}");
    }

    public void endGroup(String groupName, PrintWriter out) {
        out.println("\\vfill");
    }

    public String transformHTMLJavadocComment(String comment, final Class clazz, final String operatorName) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            comment = "<body>" + comment + "</body>";
            final StringBuffer transformed = new StringBuffer();
            final Stack closingTagStack = new Stack();
            parser.parse(new InputSource(new StringReader(comment)), new DefaultHandler(){

                public void characters(char[] ch, int start, int length) throws SAXException {
                    transformed.append(ch, start, length);
                }

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                    String latex;
                    LogService.logMessage("Entity: " + publicId, 2);
                    if (systemId.equals("&quot;")) {
                        latex = "``";
                    } else if (systemId.equals("&auml;")) {
                        latex = "\\\"a";
                    } else if (systemId.equals("&ouml;")) {
                        latex = "\\\"o";
                    } else if (systemId.equals("&uuml;")) {
                        latex = "\\\"u";
                    } else if (systemId.equals("&Auml;")) {
                        latex = "\\\"A";
                    } else if (systemId.equals("&Ouml;")) {
                        latex = "\\\"O";
                    } else if (systemId.equals("&Uuml;")) {
                        latex = "\\\"U";
                    } else if (systemId.equals("&szlig;")) {
                        latex = "\\\"s";
                    } else if (systemId.equals("&nbsp;")) {
                        latex = "\\ ";
                    } else {
                        LogService.logMessage("Unknown entity: " + systemId, 4);
                        latex = systemId;
                    }
                    return new InputSource(new StringReader(latex));
                }

                public void endElement(String uri, String localName, String qName) {
                    transformed.append(closingTagStack.pop());
                }

                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    if ((qName = qName.toLowerCase()).equals("code")) {
                        transformed.append("\\java{");
                        closingTagStack.push("}");
                    } else if (qName.equals("em")) {
                        transformed.append("\\emph{");
                        closingTagStack.push("}");
                    } else if (qName.equals("var")) {
                        transformed.append("\\para{");
                        closingTagStack.push("}");
                    } else if (qName.equals("b")) {
                        LogService.logMessage(operatorName + " (" + clazz.getName() + "): physical markup used (b,i, or tt).", 4);
                        transformed.append("\\textbf{");
                        closingTagStack.push("}");
                    } else if (qName.equals("i")) {
                        LogService.logMessage(operatorName + " (" + clazz.getName() + "): physical markup used (b,i, or tt).", 4);
                        transformed.append("\\textit{");
                        closingTagStack.push("}");
                    } else if (qName.equals("tt")) {
                        LogService.logMessage(operatorName + " (" + clazz.getName() + "): physical markup used (b,i, or tt).", 4);
                        transformed.append("\\texttt{");
                        closingTagStack.push("}");
                    } else if (qName.equals("center")) {
                        transformed.append("\n\\begin{center}\n");
                        closingTagStack.push("\n\\end{center}\n");
                    } else if (qName.equals("ol")) {
                        transformed.append("\n\\begin{enumerate}\n");
                        closingTagStack.push("\n\\end{enumerate}\n");
                    } else if (qName.equals("ul")) {
                        transformed.append("\n\\begin{itemize}\n");
                        closingTagStack.push("\n\\end{itemize}\n");
                    } else if (qName.equals("li")) {
                        transformed.append("\n\\item ");
                        closingTagStack.push("");
                    } else if (qName.equals("dl")) {
                        transformed.append("\n\\begin{description}\n");
                        closingTagStack.push("\n\\end{description}\n");
                    } else if (qName.equals("dt")) {
                        transformed.append("\n\\item[");
                        closingTagStack.push("]");
                    } else if (qName.equals("dd")) {
                        closingTagStack.push("");
                    } else if (qName.equals("body")) {
                        transformed.append("");
                        closingTagStack.push("");
                    } else if (qName.equals("sup")) {
                        transformed.append("$^{");
                        closingTagStack.push("}$");
                    } else if (qName.equals("sub")) {
                        transformed.append("$_{");
                        closingTagStack.push("}$");
                    } else if (qName.equals("br")) {
                        transformed.append("\\par\n");
                        closingTagStack.push("");
                    } else if (qName.equals("p")) {
                        transformed.append("\\par\n");
                        closingTagStack.push("");
                    } else if (qName.equals("a")) {
                        closingTagStack.push("\\footnote{\\url{" + attributes.getValue("href") + "}}");
                    } else if (qName.equals("h1") || qName.equals("h2") || qName.equals("h3") || qName.equals("h4") || qName.equals("h5")) {
                        transformed.append("\n\\paragraph{");
                        closingTagStack.push("}");
                    } else if (qName.equals("pre")) {
                        transformed.append("\\begin{verbatim}");
                        closingTagStack.push("\\end{verbatim}");
                    } else {
                        transformed.append("");
                        closingTagStack.push("");
                        LogService.logMessage("Unknown tag: " + qName + " (" + operatorName + " (" + clazz.getName() + "))", 4);
                    }
                }
            });
            StringBuffer linksReplaced = new StringBuffer();
            Pattern pattern = Pattern.compile("\\{@link (.*?)\\}");
            Matcher matcher = pattern.matcher(transformed);
            while (matcher.find()) {
                String classname = matcher.group(1);
                int period = classname.lastIndexOf(".");
                if (period != -1) {
                    classname = classname.substring(period + 1);
                }
                matcher.appendReplacement(linksReplaced, "\\\\op{" + classname + "}");
            }
            matcher.appendTail(linksReplaced);
            return linksReplaced.toString();
        }
        catch (Throwable e) {
            LogService.logMessage(operatorName + " (" + clazz.getName() + "): " + e, 6);
            return "Cannot parse class comment: " + e;
        }
    }
}

